(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    430928,      10761]
NotebookOptionsPosition[    428284,      10675]
NotebookOutlinePosition[    428697,      10691]
CellTagsIndexPosition[    428654,      10688]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Notebook for constructing and manipulating \
polynomials generated by the Matrix-Tree Theorem, as applied to the Laplacian \
matrix of a labelled, directed graph.",
 FontSize->16]], "Subsubtitle",
 CellChangeTimes->{{3.593032137145071*^9, 3.59303225480232*^9}, {
   3.593032295981461*^9, 3.59303232656314*^9}, {3.593032403282481*^9, 
   3.593032463231991*^9}, 3.593032516188328*^9, {3.593033026632361*^9, 
   3.593033110073255*^9}, {3.593033570690996*^9, 3.593033571262353*^9}, {
   3.593034258713703*^9, 3.5930342737367687`*^9}, {3.593034698528216*^9, 
   3.593034703781767*^9}, {3.5930881748683147`*^9, 3.593088179153162*^9}},
 Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell["Background", "Subsubsection",
 CellChangeTimes->{{3.5930854578272247`*^9, 3.59308547324557*^9}}],

Cell[TextData[{
 "This notebook provides capabilities for the ",
 StyleBox["linear framework",
  FontWeight->"Bold"],
 ", which is developed in a series of papers\n\n[1] J. Gunawardena, \
\[OpenCurlyDoubleQuote]",
 StyleBox["A linear framework for time-scale separation in nonlinear \
biochemical systems",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], PLoS ONE 7:e36321, 2012. \n[2] I. Mirzaev, J. \
Gunawardena, \[OpenCurlyDoubleQuote]",
 StyleBox["Laplacian dynamics on general graphs",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], Bull Math Biol 75:2118-49 2013. \n[3] J. \
Gunawardena, \[OpenCurlyDoubleQuote]",
 StyleBox["Time-scale separation: Michaelis and Menten\[CloseCurlyQuote]s old \
idea, still bearing fruit",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], FEBS J, invited review, in press, 2013\n[4] T. \
Ahsendorf, F. Wong, R. Eils, J. Gunawardena,",
 StyleBox[" \[OpenCurlyDoubleQuote]A framework for modelling gene regulation \
that accommodates non-equilibrium mechanisms",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote], submitted, 2013. \n\nThe linear framework is \
based on a labelled, directed graph, G, which gives rise to a dynamics, \
\[DifferentialD]x/\[DifferentialD]t = \[ScriptCapitalL](G).x, where \
\[ScriptCapitalL](G) is the Laplacian matrix of G [1]. This linear dynamics \
can be thought of as as first-order chemistry or as the corresponding \
stochastic master equation [2] and has wide applications in different \
biological contexts [3,4]. The steady-states of this dynamics or, \
equivalently, the elements of the kernel of the Laplacian, are the subject of \
interest. For a strongly-connected graph, the kernel of the Laplacian has \
dimension 1 and a basis element can be constructed by the Matrix-Tree Theorem \
[1]."
}], "Text",
 CellChangeTimes->{{3.5930325837677803`*^9, 3.593032692895615*^9}, {
   3.593032742085393*^9, 3.593032757113186*^9}, {3.5930328082324047`*^9, 
   3.593032876449548*^9}, {3.5930329068155117`*^9, 3.593032936144404*^9}, {
   3.593033125148706*^9, 3.593033161892479*^9}, {3.593033214496097*^9, 
   3.593033348397884*^9}, {3.593033389990787*^9, 3.593033487191668*^9}, {
   3.593033529631135*^9, 3.593033532233549*^9}, {3.593033587222403*^9, 
   3.593033588072175*^9}, {3.5930336585945873`*^9, 3.593033661125289*^9}, {
   3.593033792366529*^9, 3.593033792394074*^9}, {3.5930338343663054`*^9, 
   3.593034098863308*^9}, {3.5930341326484423`*^9, 3.593034256781238*^9}, {
   3.593034290141095*^9, 3.593034435949849*^9}, {3.593034470256555*^9, 
   3.5930345104319677`*^9}, {3.5930345456375723`*^9, 3.593034674960286*^9}, {
   3.593034713718349*^9, 3.593034785270693*^9}, {3.5930349764859962`*^9, 
   3.593035232443574*^9}, {3.593044089272188*^9, 3.59304419412757*^9}, {
   3.5930442408092327`*^9, 3.5930442534420853`*^9}, {3.593044320975276*^9, 
   3.59304472795973*^9}, {3.593044771448843*^9, 3.59304480614153*^9}, {
   3.593044850735894*^9, 3.593045000634365*^9}, {3.593045528517502*^9, 
   3.593045553033071*^9}, {3.59308543499522*^9, 3.593085448562604*^9}, {
   3.5930855671046762`*^9, 3.5930855698763638`*^9}, 3.593085606510851*^9, {
   3.593085816818892*^9, 3.59308581719915*^9}, {3.593085970348425*^9, 
   3.593085974059992*^9}, {3.593086072137556*^9, 3.5930860952580347`*^9}, 
   3.593086314577878*^9, {3.593086979780692*^9, 3.5930869953203373`*^9}, {
   3.593087353677593*^9, 3.59308737351223*^9}, 3.593087429548314*^9, {
   3.5930881309780407`*^9, 3.593088131850968*^9}},
 FontFamily->"Bitstream Vera Sans",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Usage", "Subsubsection",
 CellChangeTimes->{{3.593086100861249*^9, 3.593086107581841*^9}}],

Cell[TextData[{
 "Before using this notebook, a text file with the extension .txt should be \
created (for example, ",
 StyleBox["graph.txt",
  FontFamily->"Courier"],
 ") in which a graph is described as a list of triples, (i,a,j), signifying a \
directed edge from vertex i to vertex j with label a. The graph is assumed to \
be strongly connected. The python script ",
 StyleBox["MTT.py",
  FontFamily->"Courier"],
 " (see Further Information below) should then be executed. This reads ",
 StyleBox["graph.txt",
  FontFamily->"Courier"],
 " and produces, for each vertex i in the graph, a file ",
 StyleBox["graph-i.txt",
  FontFamily->"Courier"],
 ", which enumerates the spanning trees rooted at i, as prescribed by the \
Matrix-Tree Theorem. The script also produces a cleaned description of the \
graph in the file",
 StyleBox["graph-parsed.txt",
  FontFamily->"Courier"],
 ". This notebook reads these files and expects to be executed in the \
directory which contains them. \n\nSet the variable name ",
 StyleBox["GraphName",
  FontColor->RGBColor[1, 0, 0]],
 " below to the name of the graph in the graph description file (ie: ",
 StyleBox["GraphName",
  FontColor->RGBColor[1, 0, 0]],
 " = \[OpenCurlyDoubleQuote]",
 StyleBox["graph",
  FontFamily->"Courier"],
 "\[CloseCurlyDoubleQuote] if the file is ",
 StyleBox["graph.txt",
  FontFamily->"Courier"],
 ") and then execute the functions below. The notebook builds the basis \
vector \[Rho] (called here \
\[OpenCurlyDoubleQuote]rho\[CloseCurlyDoubleQuote]) in the kernel of the \
Laplacian matrix of the graph. For each vertex i, the i-th component of the \
basis vector is created as a polynomial in the edge labels "
}], "Text",
 CellChangeTimes->{{3.59308612060117*^9, 3.593086183016931*^9}, {
  3.593086217973568*^9, 3.59308625796673*^9}, {3.593086333820715*^9, 
  3.5930863410778008`*^9}, {3.5930863895199547`*^9, 3.593086549028178*^9}, {
  3.593086628206809*^9, 3.593086629400098*^9}, {3.593086802531786*^9, 
  3.593086868631983*^9}, {3.593086928678712*^9, 3.593086933336928*^9}, {
  3.593087162493452*^9, 3.5930871646666317`*^9}, {3.593087483677828*^9, 
  3.5930874864116173`*^9}, {3.593087644835595*^9, 3.5930876541502113`*^9}, {
  3.593397816579623*^9, 3.593397825297391*^9}},
 FontFamily->"Bitstream Vera Sans",
 FontSize->12],

Cell[TextData[Cell[BoxData[
 RowBox[{"rhoi", "[", 
  RowBox[{
   SubscriptBox["a", "1"], ",", " ", "...", " ", ",", " ", 
   SubscriptBox["a", "n"]}], "]"}]], "Text",
 CellChangeTimes->{{3.593085610301878*^9, 3.593085648961357*^9}, 
   3.593085903189748*^9, {3.593085981563904*^9, 3.593086016346689*^9}, {
   3.593086055747075*^9, 3.5930860898661013`*^9}},
 TextAlignment->Center,
 FontFamily->"Bitstream Vera Sans",
 FontSize->12]], "Text",
 CellChangeTimes->{{3.5930871005725927`*^9, 3.5930871210973587`*^9}},
 TextAlignment->Center,
 FontSize->12],

Cell[TextData[StyleBox["with the labels ordered as they appear in \
graph.txt.These polynomials can then be interrogated using Mathematica \
functions, as required, depending on the context.",
 FontFamily->"Bitstream Vera Sans"]], "Text",
 CellChangeTimes->{{3.593087136602989*^9, 3.593087158759761*^9}},
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Further information", "Subsubsection",
 CellChangeTimes->{{3.5930869460187883`*^9, 3.593086954487852*^9}}],

Cell[TextData[{
 "The script ",
 StyleBox["MTT.py",
  FontFamily->"Courier"],
 " and further details, including contact information, are available at ",
 StyleBox["vcp.med.harvard.edu/software.html#linear",
  FontVariations->{"Underline"->True}],
 ". This notebook was developed by Felix Wong for the paper [4]."
}], "Text",
 CellChangeTimes->{{3.593086961414484*^9, 3.5930869841786222`*^9}, {
  3.593087726446669*^9, 3.5930878025288467`*^9}, {3.5930878681734056`*^9, 
  3.59308786998521*^9}, {3.593087904149415*^9, 3.59308793748676*^9}},
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
This notebook has been specialised to the graph of the \
Kim-O\[CloseCurlyQuote]Shea model discussed in paper [4].\
\>", "Subsubtitle",
 CellChangeTimes->{{3.593089274950838*^9, 3.593089288274455*^9}, {
  3.593089326117437*^9, 3.593089410466136*^9}, {3.593089450952064*^9, 
  3.59308946342385*^9}},
 Background->RGBColor[1, 1, 0]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"kill", " ", "kernel"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Quit", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.569607469868877*^9, 3.569607481417492*^9}, {
   3.56960815303469*^9, 3.569608212585122*^9}, {3.5696082440098677`*^9, 
   3.569608248801093*^9}, {3.569608280216692*^9, 3.569608376791531*^9}, {
   3.569608410003973*^9, 3.569608599956274*^9}, 3.569608941585931*^9, {
   3.569609206248687*^9, 3.569609267530383*^9}, {3.569618948865366*^9, 
   3.569618951639709*^9}, {3.569619003368388*^9, 3.569619003781415*^9}, {
   3.569619361980508*^9, 3.569619362331675*^9}, {3.569619509916873*^9, 
   3.569619546616232*^9}, {3.569621106445619*^9, 3.569621153468734*^9}, {
   3.587496891552887*^9, 3.5874969520621243`*^9}, {3.587497008308509*^9, 
   3.587497060788553*^9}, 3.587497094142061*^9, {3.587497130061305*^9, 
   3.587497170046094*^9}, {3.588042550731573*^9, 3.5880426497167263`*^9}, {
   3.58807893446441*^9, 3.5880789534884453`*^9}, {3.591026813974751*^9, 
   3.5910268346970177`*^9}, {3.591026883658484*^9, 3.591026884783925*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"specify", " ", "graph"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"GraphName", " ", "=", " ", 
      StyleBox["\"\<kimoshea\>\"",
       FontSize->18]}], ";"}],
    FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"graph", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], "<>", "GraphName", "<>", 
        "\"\<-parsed.txt\>\""}], ",", "\"\<Table\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MathematicaGraph", "=", 
     RowBox[{
      RowBox[{"ToExpression", "[", 
       RowBox[{"StringReplace", "[", 
        RowBox[{
         RowBox[{"ToString", "[", "graph", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<{{\>\"", "\[Rule]", "\"\<{\>\""}], ",", 
           RowBox[{"\"\<}}\>\"", "\[Rule]", "\"\<}\>\""}], ",", 
           RowBox[{"\"\<(\>\"", "\[Rule]", "\"\<{\>\""}], ",", 
           RowBox[{"\"\<)\>\"", "\[Rule]", "\"\<}\>\""}], ",", 
           RowBox[{"\"\<'\>\"", "\[Rule]", "\"\<\\\"\>\""}]}], "}"}]}], "]"}],
        "]"}], "/.", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f_Integer", ",", "m_", ",", "l_Integer"}], "}"}], 
       "\[RuleDelayed]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "\[Rule]", "l"}], ",", 
         RowBox[{"ToString", "[", "m", "]"}]}], "}"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"get", " ", "labels"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"listoflabels", " ", "=", " ", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"MathematicaGraph", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lstring", " ", "=", " ", "\"\<{\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"m", "=", "1"}], ",", 
     RowBox[{"m", "\[LessEqual]", 
      RowBox[{"Length", "[", "listoflabels", "]"}]}], ",", 
     RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"lstring", " ", "=", " ", 
       RowBox[{"lstring", " ", "<>", " ", "\"\<{\>\"", "<>", 
        RowBox[{"ToString", "[", "m", "]"}], "<>", "\"\<,\\\"\>\"", "<>", 
        RowBox[{"listoflabels", "[", 
         RowBox[{"[", "m", "]"}], "]"}], "<>", "\"\<\\\"},\>\""}]}], ";"}]}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"flstring", " ", "=", " ", 
     RowBox[{
      RowBox[{"StringDrop", "[", 
       RowBox[{"lstring", " ", ",", 
        RowBox[{"-", "1"}]}], "]"}], "<>", " ", "\"\<}\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ToExpression", "[", 
     RowBox[{"\"\<labelrule=\>\"", "<>", "flstring"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "function", " ", "that", " ", "comes", " ", "in", " ", "handy", " ", 
     "when", " ", "plotting"}], " ", "*)"}], 
   RowBox[{
    RowBox[{"HashString", "[", "f_String", "]"}], ":=", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{"ToCharacterCode", "[", "f", "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"ToCharacterCode", "[", "f", "]"}], ".", 
      RowBox[{"ToCharacterCode", "[", "f", "]"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.569607469868877*^9, 3.569607481417492*^9}, {
   3.56960815303469*^9, 3.569608212585122*^9}, {3.5696082440098677`*^9, 
   3.569608248801093*^9}, {3.569608280216692*^9, 3.569608376791531*^9}, {
   3.569608410003973*^9, 3.569608599956274*^9}, 3.569608941585931*^9, {
   3.569609206248687*^9, 3.569609267530383*^9}, {3.569618948865366*^9, 
   3.569618951639709*^9}, {3.569619003368388*^9, 3.569619003781415*^9}, {
   3.569619361980508*^9, 3.569619362331675*^9}, {3.569619509916873*^9, 
   3.569619546616232*^9}, {3.569621106445619*^9, 3.569621153468734*^9}, {
   3.587496891552887*^9, 3.5874969520621243`*^9}, {3.587497008308509*^9, 
   3.587497060788553*^9}, 3.587497094142061*^9, {3.587497130061305*^9, 
   3.587497170046094*^9}, {3.588042550731573*^9, 3.5880426497167263`*^9}, {
   3.58807893446441*^9, 3.588078949695486*^9}, {3.591026839677394*^9, 
   3.5910268425241613`*^9}, {3.591026886798623*^9, 3.591026910410639*^9}, {
   3.591026966870488*^9, 3.591026980460433*^9}, {3.5910270136059723`*^9, 
   3.591027013942484*^9}, {3.591027080354863*^9, 3.5910270894784927`*^9}, {
   3.591027358084494*^9, 3.591027358486965*^9}, {3.591027600757772*^9, 
   3.5910277787130957`*^9}, {3.591027949211357*^9, 3.591027951180687*^9}, {
   3.591027996779153*^9, 3.591028015663887*^9}, {3.591032807539391*^9, 
   3.591032830890626*^9}, {3.591033780795171*^9, 3.591033781263668*^9}, {
   3.591921785312519*^9, 3.591921842377383*^9}, 3.591922310250311*^9, 
   3.591922342427706*^9, {3.591922418050705*^9, 3.591922421284522*^9}, {
   3.591922519534986*^9, 3.591922538025443*^9}, {3.5919227206463137`*^9, 
   3.59192272196515*^9}, {3.591924085604554*^9, 3.5919240873727703`*^9}, {
   3.5919292494494143`*^9, 3.59192925850169*^9}, 3.591929644332284*^9, {
   3.593034815354805*^9, 3.5930348161086063`*^9}, {3.593034866082608*^9, 
   3.593034867289253*^9}, {3.593034938498311*^9, 3.593034941177024*^9}, {
   3.593088760261348*^9, 3.593088762010661*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell["\<\
Check to see what the graph looks like\
\>", "Text",
 CellChangeTimes->{{3.593088326156517*^9, 3.5930883433995256`*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"plot", " ", "graph"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{"MathematicaGraph", ",", " ", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexCoordinateRules", "\[Rule]", "Auto"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"VertexRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"White", ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{"#2", ",", "#1"}], "]"}], ",", "Large", ",", "Italic", 
           ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], 
        "}"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"HashString", "[", "#3", "]"}], ",", "1", ",", "0.7"}], 
          "]"}], "\[IndentingNewLine]", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"#1", ",", "0.1"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"#3", "=!=", "None"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"#3", ",", "Medium", ",", 
               RowBox[{"Hue", "[", 
                RowBox[{
                 RowBox[{"HashString", "[", "#3", "]"}], ",", "1", ",", 
                 "0.7"}], "]"}], ",", "Italic", ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "#1", "]"}], ">", "2"}], ",", 
               RowBox[{
                RowBox[{"Mean", "[", "#1", "]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "*", "0.5"}]}], 
               ",", 
               RowBox[{"Mean", "[", "#1", "]"}]}], "]"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", "700"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.569607469868877*^9, 3.569607481417492*^9}, {
   3.56960815303469*^9, 3.569608212585122*^9}, {3.5696082440098677`*^9, 
   3.569608248801093*^9}, {3.569608280216692*^9, 3.569608376791531*^9}, {
   3.569608410003973*^9, 3.569608599956274*^9}, 3.569608941585931*^9, {
   3.569609206248687*^9, 3.569609267530383*^9}, {3.569618948865366*^9, 
   3.569618951639709*^9}, {3.569619003368388*^9, 3.569619003781415*^9}, {
   3.569619361980508*^9, 3.569619362331675*^9}, {3.569619509916873*^9, 
   3.569619546616232*^9}, {3.569621106445619*^9, 3.569621153468734*^9}, {
   3.587496891552887*^9, 3.5874969520621243`*^9}, {3.587497008308509*^9, 
   3.587497060788553*^9}, 3.587497094142061*^9, {3.587497130061305*^9, 
   3.587497170046094*^9}, {3.588042550731573*^9, 3.5880426497167263`*^9}, {
   3.58807893446441*^9, 3.588078949695486*^9}, {3.591026839677394*^9, 
   3.5910268425241613`*^9}, {3.591026886798623*^9, 3.591026910410639*^9}, {
   3.591026966870488*^9, 3.591026980460433*^9}, {3.5910270136059723`*^9, 
   3.591027013942484*^9}, {3.591027080354863*^9, 3.5910270894784927`*^9}, {
   3.591027351758572*^9, 3.5910273549353933`*^9}, {3.591919065489099*^9, 
   3.591919074884701*^9}, 3.591921266564002*^9, {3.591921309404653*^9, 
   3.591921322895782*^9}, {3.591921803210824*^9, 3.59192180348807*^9}, {
   3.591922390321838*^9, 3.59192243140271*^9}, {3.591922887508726*^9, 
   3.5919229862478533`*^9}, {3.5919230561887007`*^9, 3.591923074637396*^9}, {
   3.591923119562149*^9, 3.5919231697233458`*^9}, {3.591923267241754*^9, 
   3.5919232982758923`*^9}, {3.5919233703168364`*^9, 
   3.5919234623768473`*^9}, {3.5919234967812033`*^9, 
   3.5919236636758957`*^9}, {3.591923701521368*^9, 3.591923824481277*^9}, {
   3.591923857713616*^9, 3.5919239480553627`*^9}, {3.59192402836586*^9, 
   3.591924062163271*^9}, {3.591924144865118*^9, 3.591924145078718*^9}, {
   3.5919241821475687`*^9, 3.591924206894228*^9}, {3.5919244113802233`*^9, 
   3.591924411499074*^9}, {3.591924548606723*^9, 3.591924666758247*^9}, {
   3.591924698563945*^9, 3.591924760152013*^9}, {3.591924817272084*^9, 
   3.5919248267448187`*^9}, {3.591924858170093*^9, 3.591924910930765*^9}, {
   3.591925015069928*^9, 3.591925052364744*^9}, {3.591926877205414*^9, 
   3.591926897875875*^9}, {3.5919270350864277`*^9, 3.5919271111377707`*^9}, {
   3.591927143551525*^9, 3.59192721270188*^9}, {3.591927247921213*^9, 
   3.591927321978053*^9}, {3.5919274458287477`*^9, 3.591927466649723*^9}, {
   3.591927674939842*^9, 3.591927678861436*^9}, {3.591927758728633*^9, 
   3.591927805846252*^9}, {3.5919278437792788`*^9, 3.5919278834475*^9}, {
   3.591927974586871*^9, 3.5919281410257874`*^9}, {3.591928190495051*^9, 
   3.591928320853825*^9}, 3.591928383903995*^9, {3.5919284428532352`*^9, 
   3.591928508114943*^9}, {3.591928607360139*^9, 3.591928647535407*^9}, {
   3.591928730669959*^9, 3.591928760128909*^9}, {3.591929028085205*^9, 
   3.591929035824223*^9}, 3.591929164643072*^9, {3.5919292062068243`*^9, 
   3.591929229030966*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 GraphicsBox[
  TagBox[{{
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{2.9157490156441668`, 0.921214030135123}, {
       2.9076597078293207`, 0.8240332414093551}, {2.905038480896909, 
       0.7980514332140155}, {2.9015097605332865`, 0.772177250708553}, {
       2.897077868226912, 0.7464423810116745}, {2.891748231546272, 
       0.7208783406310345}, {2.8855273774929495`, 0.6955164368661771}, {
       2.8784229245082544`, 0.6703877294676883}, {2.870443573143209, 
       0.6455229925995095}, {2.7520600720531854`, 0.2976655260670299}, {
       2.743215594313296, 0.27309521061852116`}, {2.7335168216911514`, 
       0.2488494069124248}, {2.7229756319015093`, 0.2249578078544011}, {
       2.7116049343351145`, 0.20144967256926624`}, {2.699418654249064, 
       0.17835379056846468`}, {2.686431715713079, 0.15569844649265854`}, {
       2.6726600233325684`, 0.13351138547261363`}, {2.619790262919107, 
       0.05157036380392277}}, 0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {2.803758578925721, 0.5241112524963525},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{2.619790262919107, 0.05157036380392277}, {
       2.6278795707339535`, 0.14875115252969087`}, {2.630500797666365, 
       0.1747329607250305}, {2.6340295180299877`, 0.2006071432304929}, {
       2.638461410336362, 0.2263420129273714}, {2.643791047017002, 
       0.25190605330801147`}, {2.6500119010703247`, 0.2772679570728688}, {
       2.65711635405502, 0.30239666447135766`}, {2.665095705420065, 
       0.3272614013395364}, {2.783479206510089, 0.6751188678720161}, {
       2.792323684249978, 0.6996891833205248}, {2.802022456872123, 
       0.7239349870266212}, {2.812563646661765, 0.7478265860846448}, {
       2.82393434422816, 0.7713347213697798}, {2.8361206243142103`, 
       0.7944306033705812}, {2.849107562850195, 0.8170859474463875}, {
       2.8628792552307063`, 0.8392730084664324}, {2.9157490156441668`, 
       0.921214030135123}}, 0.1], InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {2.7317806996375533`, 0.4486731414426934},
       
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], 
      ArrowBox[{{2.619790262919107, 0.05157036380392277}, {2.505843996199126, 
       0.01744084624347131}, {2.475175486806246, 0.008836732410418047}, {
       2.444224700392819, 0.001310972407352451}, {
       2.4130295411996054`, -0.0051272172561595}, {
       2.3816282127413326`, -0.010469951976223801`}, {
       2.350059171020319, -0.014710688710592001`}, {
       2.318361077430882, -0.0178442339916719}, {
       2.2865727514122103`, -0.019866750286769652`}, {
       1.8388447118160864`, -0.04049489580833865}, {
       1.8070050833115638`, -0.041403906219337316`}, {
       1.775153145092761, -0.041198297516058524`}, {
       1.7433279050064823`, -0.039878321499593694`}, {
       1.7115683382033546`, -0.03744559469393183}, {
       1.679913339406454, -0.03390309636626576}, {
       1.64840167527843, -0.029255164878396855`}, {
       1.6170719369454631`, -0.023507492373710415`}, {1.5004701639287972`, 
       0.}}, 0.1], InsetBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {2.1189976610883816`, 0.0017343867406765454`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.7260532863903684`, 0.9148143915310374}, {
       1.7263746508919309`, 0.814793583559023}, {1.7259920357562015`, 
       0.788011964030185}, {1.7246725711729958`, 0.761260131342625}, {
       1.7224178730399704`, 0.7345708474395588}, {1.719230702599432, 
       0.7079767976631053}, {1.7151149630567504`, 0.6815105507258015}, {
       1.7100756948002518`, 0.6552045188249507}, {1.7041190692284491`, 
       0.6290909179486471}, {1.6138858202438207`, 0.2631651613362326}, {
       1.6070191322075384`, 0.23727597180967702`}, {1.5992507910761893`, 
       0.21164289913009918`}, {1.5905903104391408`, 0.18629733513825159`}, {
       1.581048296454788, 0.16127031957402677`}, {1.5706364348615989`, 
       0.13659250206327822`}, {1.5593674766670378`, 0.1122941045823996}, {
       1.5472552225318958`, 0.08840488444662975}, {1.5004701639287972`, 0.}}, 
       0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.6467045674907275`, 0.49913134182742547`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.7260532863903684`, 0.9148143915310374}, {1.607015639732421,
        0.882960850457413}, {1.5749946010041103`, 0.8749899751629472}, {
       1.5427142703457504`, 0.8681443906892257}, {1.5102141802399331`, 
       0.8624324805609371}, {1.4775341323002138`, 0.857861239935291}, {
       1.4447141485276047`, 0.854436267035315}, {1.4117944222971635`, 
       0.8521617562939283}, {1.378815269134709, 0.8510404932171792}, {
       0.9145553768432905, 0.843385277513938}, {0.8815571850525268, 
       0.8434186352697015}, {0.8485803662530346, 0.8446065730060142}, {
       0.8156653058897124, 0.8469476359011026}, {0.7828523137742714, 
       0.8504389569450493}, {0.7501815747193551, 0.8550762604509087}, {
       0.7176930993257407, 0.8608538672909776}, {0.6854266749828919, 
       0.8677647018518045}, {0.5654035556618213, 0.8956763522729346}}, 0.1], 
      InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.20595023457758, 0.8785384430582404},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.7260532863903684`, 0.9148143915310374}, {
       2.9157490156441668`, 0.921214030135123}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.3209011510172677`, 0.9180142108330802},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.5004701639287972`, 0.}, {
       1.384502282385536, -0.026820726023775054`}, {
       1.3533267410568066`, -0.0334584718516705}, {
       1.3219380360184496`, -0.039001326967047834`}, {
       1.2903746078133644`, -0.04344250324788679}, {
       1.2586751109612107`, -0.046776561755972335`}, {
       1.2268783666196994`, -0.048999419397753985`}, {
       1.195023315041812, -0.05010835392475277}, {
       1.1631489678871643`, -0.050102007267395554`}, {
       0.7147102255050701, -0.042164893226907196`}, {
       0.6828556180638317, -0.04104327315770173}, {
       0.6510597614517017, -0.03880775328171804}, {
       0.619361594834493, -0.035461071354387586`}, {
       0.5877999377408292, -0.031007325928678164`}, {
       0.5564134425213574, -0.025451971335754497`}, {
       0.525240547012697, -0.0188018110052669}, {
       0.49431942746409596`, -0.011064989133453218`}, {0.37937330797355995`, 
       0.01984278510122095}}, 0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.997176799342768, -0.01784906330805143},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{1.5004701639287972`, 0.}, {1.500148799427235, 
       0.10002080797201446`}, {1.5005314145629645`, 0.12680242750085258`}, {
       1.50185087914617, 0.1535542601884125}, {1.5041055772791956`, 
       0.1802435440914787}, {1.5072927477197338`, 0.2068375938679323}, {
       1.5114084872624158`, 0.23330384080523603`}, {1.5164477555189144`, 
       0.2596098727060868}, {1.5224043810907166`, 0.28572347358239036`}, {
       1.612637630075345, 0.6516492301948048}, {1.6195043181116273`, 
       0.6775384197213604}, {1.6272726592429767`, 0.7031714924009382}, {
       1.635933139880025, 0.7285170563927859}, {1.6454751538643775`, 
       0.7535440719570107}, {1.6558870154575671`, 0.7782218894677593}, {
       1.667155973652128, 0.8025202869486378}, {1.67926822778727, 
       0.8264095070844077}, {1.7260532863903684`, 0.9148143915310374}}, 0.1], 
      InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {1.579818882828438, 0.4156830497036119},
       
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], 
      ArrowBox[{{1.5004701639287972`, 0.}, {1.4475641207127163`, 
       0.07538604531997792}, {1.4337519996814665`, 0.09581821141897567}, {
       1.4206632538134953`, 0.11672114974071912`}, {1.408313912393747, 
       0.13806926125854235`}, {1.396719099186901, 0.15983640175924407`}, {
       1.385893013915882, 0.1819959138609029}, {1.3758489148720023`, 
       0.20452065965915034`}, {1.3665991026780397`, 0.227383053961921}, {
       1.2420924402904459`, 0.5513115696424136}, {1.2336482428365454`, 
       0.5744836137524717}, {1.2260200014073852`, 0.5979369297563416}, {
       1.2192170580176027`, 0.6216427952776498}, {1.2132477439709866`, 
       0.6455721786523171}, {1.20811936965745, 0.6696957744825244}, {
       1.2038382156002754`, 0.6939840395259084}, {1.2004095247645994`, 
       0.718407228876038}, {1.1892035079598116`, 0.8098212892012325}}, 0.1], 
      InsetBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {1.3415430041462706`, 0.3557839837925849},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.5004701639287972`, 0.}, {1.6144164306487785`, 
       0.03412951756045146}, {1.6450849400416585`, 0.04273363139350472}, {
       1.6760357264550854`, 0.05025939139657032}, {1.7072308856482992`, 
       0.05669758106008227}, {1.738632214106572, 0.06204031578014657}, {
       1.7702012558275853`, 0.06628105251451477}, {1.8018993494170226`, 
       0.06941459779559467}, {1.8336876754356946`, 0.07143711409069242}, {
       2.281415715031818, 0.09206525961226142}, {2.3132553435363405`, 
       0.09297427002326009}, {2.3451072817551437`, 0.0927686613199813}, {
       2.376932521841422, 0.09144868530351646}, {2.4086920886445498`, 
       0.0890159584978546}, {2.440347087441451, 0.08547346017018853}, {
       2.4718587515694743`, 0.08082552868231963}, {2.5031884899024415`, 
       0.07507785617763318}, {2.619790262919107, 0.05157036380392277}}, 0.1], 
      InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.0012627657595226`, 0.04983597706324623},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{0.5654035556618213, 0.8956763522729346}, {0.56879468527807, 
       0.8006883593507694}, {0.569257567541922, 0.7752398692885019}, {
       0.5688297285787189, 0.7497907659592862}, {0.5675116923464258, 
       0.7243722159036695}, {0.5653050729934528, 0.6990153482447765}, {
       0.5622125728818692, 0.6737512165656669}, {0.5582379792779244, 
       0.648610760879204}, {0.5533861597139285, 0.6236247697370069}, {
       0.4789740606386241, 0.273291342868322}, {0.4732509569518674, 
       0.24849041565520835`}, {0.4666635780078805, 0.2239049251153016}, {
       0.4592199911169452, 0.19956498015569607`}, {0.45092931215436965`, 
       0.17550038897323397`}, {0.4418016943966252, 0.15174062254954965`}, {
       0.431848316087018, 0.12831477855908968`}, {0.4210813667461239, 
       0.10525154573430667`}, {0.37937330797355995`, 0.01984278510122095}}, 
       0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.5028645239889393, 0.4984201877340683},
       
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], 
      ArrowBox[{{0.5654035556618213, 0.8956763522729346}, {0.6844412023197691,
        0.9275298933465591}, {0.7164622410480798, 0.9355007686410252}, {
       0.7487425717064394, 0.9423463531147467}, {0.781242661812257, 
       0.9480582632430351}, {0.8139227097519761, 0.9526295038686813}, {
       0.8467426935245853, 0.9560544767686573}, {0.8796624197550268, 
       0.9583289875100438}, {0.912641572917481, 0.959450250586793}, {
       1.3769014652088993`, 0.967105466290034}, {1.4098996569996631`, 
       0.9670721085342704}, {1.4428764757991555`, 0.9658841707979579}, {
       1.4757915361624776`, 0.9635431079028695}, {1.5086045282779186`, 
       0.9600517868589227}, {1.5412752673328352`, 0.9554144833530632}, {
       1.5737637427264495`, 0.9496368765129944}, {1.6060301670692982`, 
       0.9427260419521676}, {1.7260532863903684`, 0.9148143915310374}}, 0.1], 
      InsetBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {1.0855066074746096`, 0.9319523007457319},
       
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], 
      ArrowBox[{{0.5654035556618213, 0.8956763522729346}, {0.5175887587831978,
        0.9689167298139901}, {0.5051297418929062, 0.9887505475607788}, {
       0.49337233552435955`, 1.0090081590628852`}, {0.48233093852208964`, 
       1.0296647556006424`}, {0.4720190728614261, 1.0506950398327168`}, {
       0.4624493670886499, 1.0720732567767912`}, {0.45363354085530083`, 
       1.093773225350704}, {0.4455823905655655, 1.1157683704354153`}, {
       0.3377261803136623, 1.4272004296940395`}, {0.330449565902436, 
       1.4494638146791612`}, {0.3239563987602361, 1.471968174451189}, {
       0.3182546308197651, 1.494685948784042}, {0.313351244817484, 
       1.5175893160910132`}, {0.3092522457421214, 1.540650227496801}, {
       0.3059626534805957, 1.563840441187889}, {0.30348649667035166`, 
       1.5871315569992128`}, {0.29576303003206283`, 1.6742565004194954`}}, 
       0.1], InsetBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {0.4258914066778692, 1.2384416360355668`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{0.37937330797355995`, 0.01984278510122095}, {
       0.3759821783573115, 0.11483077802338607`}, {0.37551929609345935`, 
       0.14027926808565377`}, {0.37594713505666244`, 0.1657283714148694}, {
       0.3772651712889554, 0.1911469214704861}, {0.3794717906419286, 
       0.21650378912937907`}, {0.3825642907535123, 0.24176792080848855`}, {
       0.386538884357457, 0.2669083764949515}, {0.3913907039214528, 
       0.2918943676371487}, {0.46580280299675736`, 0.6422277945058337}, {
       0.4715259066835139, 0.6670287217189472}, {0.478113285627501, 
       0.6916142122588541}, {0.48555687251843616`, 0.7159541572184596}, {
       0.4938475514810118, 0.7400187484009217}, {0.5029751692387562, 
       0.763778514824606}, {0.5129285475483634, 0.787204358815066}, {
       0.5236954968892575, 0.8102675916398491}, {0.5654035556618213, 
       0.8956763522729346}}, 0.1], InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {0.4419123396464419, 0.4170989496400872},
       
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], 
      ArrowBox[{{0.37937330797355995`, 0.01984278510122095}, {
       0.49534118951682143`, 0.046663511124996004`}, {0.5265167308455506, 
       0.05330125695289145}, {0.5579054358839077, 0.058844112068268783`}, {
       0.5894688640889929, 0.06328528834910774}, {0.6211683609411467, 
       0.06661934685719328}, {0.6529651052826578, 0.06884220449897493}, {
       0.6848201568605454, 0.06995113902597372}, {0.716694504015193, 
       0.0699447923686165}, {1.1651332463972872`, 0.062007678328128146`}, {
       1.1969878538385257`, 0.06088605825892268}, {1.2287837104506556`, 
       0.05865053838293899}, {1.2604818770678643`, 0.055303856455608535`}, {
       1.2920435341615282`, 0.050850111029899114`}, {1.323430029381, 
       0.04529475643697545}, {1.3546029248896605`, 0.03864459610648785}, {
       1.3855240444382613`, 0.030907774234674168`}, {1.5004701639287972`, 
       0.}}, 0.1], InsetBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {0.882666672559589, 0.03769184840927238},
       
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], 
      ArrowBox[{{0.37937330797355995`, 0.01984278510122095}, {
       0.3201341986299272, 0.09075153272972236}, {0.30460544922306787`, 
       0.11001459716594492`}, {0.2897602194808284, 0.1298092141997556}, {
       0.27561668978656895`, 0.15011114212305143`}, {0.2621921811785196, 
       0.1708955179435448}, {0.24950313413737013`, 0.19213688783351635`}, {
       0.23756508845224367`, 0.21380923830214182`}, {0.22639266418971304`, 
       0.23588602805321557`}, {0.07464334100028924, 0.5492352391874447}, {
       0.06425022059974272, 0.5716894316234875}, {0.05464913211702482, 
       0.5944935279564301}, {0.04585183363687528, 0.6176196008843238}, {
       0.03786909887325329, 0.6410393287928362}, {0.03071070397518294, 
       0.6647240304396456}, {0.024385415554279644`, 0.6886447000792583}, {
       0.01890097994861628, 0.7127720429852317}, {0., 0.8032158129367948}}, 
       0.1], InsetBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {0.1905308690472088, 0.3621395516489474},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{0.29576303003206283`, 1.6742565004194954`}, {
       0.28772984718330247`, 1.5769368775847765`}, {0.2851229969305868, 
       1.5509176342119424`}, {0.2816073345936909, 1.5250055364144315`}, {
       0.2771871656694081, 1.4992323177443534`}, {0.2718679033690495, 
       1.4736295416738794`}, {0.26565606198909225`, 1.448228562940667}, {
       0.25855924893337023`, 1.4230604891489167`}, {0.25058615539657897`, 
       1.398156142673082}, {0.13228094338375396`, 1.0497398676800018`}, {
       0.12344133370767707`, 1.0251297479178094`}, {0.11374603342317224`, 
       1.0008439939388172`}, {0.10320691599255838`, 0.9769123475742524}, {
       0.09183688826864189, 0.9533641169933313}, {0.07964987468818963, 
       0.930228140810669}, {0.06666080021920484, 0.9075327527687336}, {
       0.05288557208289146, 0.8853057470386003}, {0., 0.8032158129367948}}, 
       0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.18389370841678193`, 1.2765318186657235`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], 
      ArrowBox[{{0.29576303003206283`, 1.6742565004194954`}, {
       0.4097503797271247, 1.708348670228253}, {0.44042971390143726`, 
       1.7169425918726473`}, {0.4713909618452216, 1.724457787171017}, {
       0.5025962065058829, 1.7308850525519852`}, {0.5340072320174081, 
       1.7362165167902077`}, {0.5655855705018697, 1.7404456506459627`}, {
       0.5972925491795616, 1.7435672748612578`}, {0.6290893377300676, 
       1.745577566502672}, {1.076933426869786, 1.7660316397569538`}, {
       1.1087810849859843`, 1.7669281368974339`}, {1.1406406100627469`, 
       1.7667097416313242`}, {1.172472984961935, 1.765376721418929}, {
       1.2042392257951913`, 1.7629307087589638`}, {1.23590042966601, 
       1.7593746991892971`}, {1.2674178223126262`, 1.7547130476184303`}, {
       1.2987528055933621`, 1.748951462992208}, {1.4153732528813605`, 
       1.7253916835552001`}}, 0.1], InsetBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {0.7966961376285602, 1.7239042180324122`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{0.29576303003206283`, 1.6742565004194954`}, {
       0.3435778269106864, 1.6010161228784403`}, {0.35603684380097816`, 
       1.5811823051316514`}, {0.3677942501695247, 1.5609246936295451`}, {
       0.3788356471717945, 1.540268097091788}, {0.3891475128324582, 
       1.5192378128597135`}, {0.3987172186052342, 1.497859595915639}, {
       0.40753304483858344`, 1.4761596273417263`}, {0.4155841951283187, 
       1.4541644822570148`}, {0.523440405380222, 1.142732422998391}, {
       0.5307170197914483, 1.1204690380132691`}, {0.5372101869336482, 
       1.0979646782412413`}, {0.542911954874119, 1.0752469039083885`}, {
       0.5478153408764003, 1.0523435366014169`}, {0.5519143399517628, 
       1.0292826251956293`}, {0.5552039322132885, 1.0060924115045413`}, {
       0.5576800890235325, 0.9828012956932177}, {0.5654035556618213, 
       0.8956763522729346}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.43527517901601503`, 1.3314912166568635`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{0., 0.8032158129367948}, {0.008033182848760312, 
       0.900535435771514}, {0.010640033101476098`, 0.9265546791443481}, {
       0.014155695438371918`, 0.9524667769418593}, {0.01857586436265468, 
       0.9782399956119373}, {0.0238951266630133, 1.0038427716824114`}, {
       0.030106968042970528`, 1.0292437504156235`}, {0.0372037810986926, 
       1.054411824207374}, {0.04517687463548392, 1.0793161706832088`}, {
       0.16348208664830888`, 1.4277324456762885`}, {0.17232169632438576`, 
       1.4523425654384812`}, {0.1820169966088906, 1.4766283194174734`}, {
       0.19255611403950446`, 1.5005599657820383`}, {0.20392614176342094`, 
       1.524108196362959}, {0.2161131553438732, 1.5472441725456216`}, {
       0.229102229812858, 1.569939560587557}, {0.24287745794917137`, 
       1.5921665663176903`}, {0.29576303003206283`, 1.6742565004194954`}}, 
       0.1], InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {0.11186932161528092`, 1.200940494690567},
       
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], 
      ArrowBox[{{0., 0.8032158129367948}, {0.12230094767081319`, 
       0.8345138366520465}, {0.15519311737515168`, 0.8423206841427172}, {
       0.18833830628777734`, 0.8489718605460272}, {0.22169592276737332`, 
       0.8544592204213937}, {0.2552251150207307, 0.8587760436096875}, {
       0.2888848211323725, 0.8619170434631565}, {0.3226338193515067, 
       0.8638783733197771}, {0.3564307785747224, 0.8646576312141168}, {
       0.8321121817586463, 0.867299821719892}, {0.8659157121465308, 
       0.8668960533247018}, {0.8996844158122186, 0.8653097531196455}, {
       0.9333769375197941, 0.8625428637857294}, {0.966952015330464, 
       0.8585987738261749}, {1.0003685311344694`, 0.853482313416649}, {
       1.0335855610068585`, 0.847199748489933}, {1.066562425325447, 
       0.8397587730622754}, {1.1892035079598116`, 0.8098212892012325}}, 0.1], 
      InsetBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {0.5332086437298539, 0.8345520934897046},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{0., 0.8032158129367948}, {0.059239109343632745`, 
       0.7323070653082935}, {0.07476785875049219, 0.7130440008720709}, {
       0.08961308849273164, 0.6932493838382603}, {0.103756618186991, 
       0.6729474559149644}, {0.11718112679504034`, 0.6521630800944711}, {
       0.12987017383618982`, 0.6309217102044995}, {0.14180821952131634`, 
       0.609249359735874}, {0.15298064378384696`, 0.5871725699848003}, {
       0.3047299669732707, 0.27382335885057113`}, {0.3151230873738173, 
       0.2513691664145284}, {0.3247241758565352, 0.22856507008158589`}, {
       0.33352147433668466`, 0.20543899715369215`}, {0.3415042091003067, 
       0.1820192692451797}, {0.348662603998377, 0.15833456759837022`}, {
       0.3549878924192803, 0.1344138979587576}, {0.36047232802494367`, 
       0.11028655505278409`}, {0.37937330797355995`, 0.01984278510122095}}, 
       0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.18884243892635125`, 0.46091904638906833`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.4153732528813605`, 1.7253916835552001`}, {
       1.4156536680083516`, 1.6252779146269758`}, {1.4152596532856616`, 
       1.5984715971004182`}, {1.4139279319176072`, 1.5716954804078471`}, {
       1.411660134812259, 1.5449823562321672`}, {1.4084590392537326`, 
       1.5183649391117648`}, {1.4043285655009554`, 1.4918758263762666`}, {
       1.399273771986676, 1.4655474582258416`}, {1.3933008491225942`, 
       1.4394120780029322`}, {1.3028329511539747`, 1.0731839202613456`}, {
       1.2959492137495845`, 1.0472735349634825`}, {1.2881630920540046`, 
       1.021619876045544}, {1.279484121431778, 0.9962543605594583}, {
       1.2699229306852757`, 0.971208052678948}, {1.2594912290380096`, 
       0.9465116256564261}, {1.248201791794798, 0.9221953242586417}, {
       1.236068444696337, 0.8982889277270734}, {1.1892035079598116`, 
       0.8098212892012325}}, 0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.335779467399436, 1.3093555647414212`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.4153732528813605`, 1.7253916835552001`}, {
       1.3013859031862987`, 1.6912995137464426`}, {1.270706569011986, 
       1.6827055921020486`}, {1.239745321068202, 1.675190396803679}, {
       1.2085400764075405`, 1.6687631314227107`}, {1.1771290508960155`, 
       1.663431667184488}, {1.1455507124115536`, 1.6592025333287332`}, {
       1.1138437337338618`, 1.656080909113438}, {1.0820469451833559`, 
       1.6540706174720237`}, {0.6342028560436375, 1.633616544217742}, {
       0.6023551979274394, 1.632720047077262}, {0.5704956728506767, 
       1.6329384423433715`}, {0.5386632979514885, 1.6342714625557668`}, {
       0.5068970571182325, 1.636717475215732}, {0.4752358532474134, 
       1.6402734847853986`}, {0.44371846060079756`, 1.6449351363562654`}, {
       0.4123834773200614, 1.6506967209824879`}, {0.29576303003206283`, 
       1.6742565004194954`}}, 0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.9144401452848635, 1.6757439659422835`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.4153732528813605`, 1.7253916835552001`}, {
       1.7260532863903684`, 0.9148143915310374}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.5707132696358643`, 1.3201030375431189`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.4153732528813605`, 1.7253916835552001`}, {
       2.5363992537438307`, 1.704857315415098}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.9758862533125956`, 1.7151244994851491`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{1.1892035079598116`, 0.8098212892012325}, {
       1.0669025602889985`, 0.778523265485981}, {1.0340103905846603`, 
       0.7707164179953103}, {1.0008652016720343`, 0.7640652415920002}, {
       0.9675075851924384, 0.7585778817166339}, {0.9339783929390811, 
       0.75426105852834}, {0.9003186868274392, 0.751120058674871}, {
       0.8665696886083051, 0.7491587288182502}, {0.8327727293850894, 
       0.7483794709239107}, {0.35709132620116535`, 0.7457372804181355}, {
       0.32328779581328076`, 0.7461410488133258}, {0.2895190921475931, 
       0.7477273490183819}, {0.2558265704400174, 0.7504942383522979}, {
       0.22225149262934757`, 0.7544383283118524}, {0.18883497682534212`, 
       0.7595547887213784}, {0.155617946952953, 0.7658373536480944}, {
       0.12264108263436459`, 0.7732783290757519}, {0., 0.8032158129367948}}, 
       0.1], InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.6559948642299577, 0.7784850086483226},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{1.1892035079598116`, 0.8098212892012325}, {1.188923092832821,
        0.9099350581294575}, {1.1893171075555107`, 0.9367413756560149}, {
       1.1906488289235648`, 0.963517492348586}, {1.1929166260289132`, 
       0.9902306165242657}, {1.1961177215874397`, 1.0168480336446684`}, {
       1.2002481953402167`, 1.0433371463801666`}, {1.2053029888544966`, 
       1.0696655145305916`}, {1.211275911718578, 1.095800894753501}, {
       1.3017438096871974`, 1.4620290524950874`}, {1.308627547091588, 
       1.4879394377929505`}, {1.3164136687871677`, 1.5135930967108893`}, {
       1.325092639409394, 1.5389586121969747`}, {1.3346538301558968`, 
       1.564004920077485}, {1.3450855318031625`, 1.5887013471000069`}, {
       1.3563749690463744`, 1.6130176484977912`}, {1.368508316144835, 
       1.6369240450293596`}, {1.4153732528813605`, 1.7253916835552001`}}, 
       0.1], InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {1.2687972934417358`, 1.225857408015011},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.1892035079598116`, 0.8098212892012325}, {
       1.2421095511758926`, 0.7344352438812546}, {1.2559216722071427`, 
       0.7140030777822568}, {1.2690104180751136`, 0.6931001394605134}, {
       1.2813597594948622`, 0.6717520279426902}, {1.292954572701708, 
       0.6499848874419885}, {1.303780657972727, 0.6278253753403296}, {
       1.3138247570166066`, 0.6053006295420822}, {1.3230745692105694`, 
       0.5824382352393116}, {1.4475812315981633`, 0.258509719558819}, {
       1.4560254290520638`, 0.23533767544876097`}, {1.4636536704812237`, 
       0.21188435944489104`}, {1.4704566138710065`, 0.18817849392358288`}, {
       1.4764259279176226`, 0.1642491105489155}, {1.4815543022311592`, 
       0.14012551471870827`}, {1.4858354562883338`, 0.11583724967532419`}, {
       1.4892641471240098`, 0.09141406032519453}, {1.5004701639287972`, 0.}}, 
       0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.3481306677423381`, 0.45403730540864756`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{1.1892035079598116`, 0.8098212892012325}, {
       1.3082571488813548`, 0.8418036440545837}, {1.340283073572364, 
       0.849808933706284}, {1.3725694913533608`, 0.8566887405053698}, {
       1.4050768622870882`, 0.8624346390163836}, {1.4377653758434394`, 
       0.8670395924578478}, {1.4705949996538872`, 0.8704979613199422}, {
       1.5035255285375888`, 0.8728055102709937}, {1.53651663373913, 
       0.8739594133443269}, {2.000952715645941, 0.8820708985506506}, {
       2.0339639942244148`, 0.8820697426054381}, {2.066955018533353, 
       0.8809135290573219}, {2.0998853857309157`, 0.8786036738766786}, {
       2.132714767259697, 0.8751430058545353}, {2.16540295823557, 
       0.8705357631382575}, {2.1979099266850577`, 0.864787588041253}, {
       2.2301958625709606`, 0.8579055201330464}, {2.3502937127268395`, 
       0.8301000022170418}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.7094768997303822`, 0.8466193474261683},
       
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], 
      ArrowBox[{{2.5363992537438307`, 1.704857315415098}, {2.539754919514489, 
       1.6099782227806032`}, {2.5402088167607664`, 1.5845590564420706`}, {
       2.5397730243132655`, 1.5591395732648134`}, {2.538448075870278, 
       1.5337509035147145`}, {2.5362355940453343`, 1.5084241397216347`}, {
       2.533138288380047, 1.4831902986015844`}, {2.5291599520258434`, 
       1.458080283071741}, {2.5243054570986363`, 1.4331248444048315`}, {
       2.4498632406918404`, 1.0832219191256094`}, {2.4441385323053346`, 
       1.0584516192900073`}, {2.4375506212902747`, 1.0338967935216612`}, {
       2.4301075756085506`, 1.0095875131736969`}, {2.421818510472671, 
       0.9855535488891827}, {2.412693577182716, 0.961824334142166}, {
       2.4027439506944273`, 0.9384289291916268}, {2.391981815933669, 
       0.9153959854924938}, {2.3502937127268395`, 0.8301000022170418}}, 0.1], 
      InsetBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {2.4738007737068273`, 1.3080820619983906`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{2.5363992537438307`, 1.704857315415098}, {
       2.9157490156441668`, 0.921214030135123}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.7260741346939987`, 1.3130356727751105`},
       
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], 
      ArrowBox[{{2.3502937127268395`, 0.8301000022170418}, {
       2.3469380469561822`, 0.9249790948515371}, {2.3464841497099047`, 
       0.9503982611900696}, {2.3469199421574056`, 0.9758177443673268}, {
       2.3482448906003928`, 1.0012064141174257`}, {2.3504573724253373`, 
       1.0265331779105056`}, {2.3535546780906236`, 1.051767019030556}, {
       2.3575330144448277`, 1.0768770345603993`}, {2.3623875093720343`, 
       1.101832473227309}, {2.436829725778831, 1.4517353985065309`}, {
       2.442554434165337, 1.476505698342133}, {2.4491423451803964`, 
       1.501060524110479}, {2.456585390862121, 1.5253698044584434`}, {
       2.4648744559980003`, 1.5494037687429576`}, {2.4739993892879553`, 
       1.5731329834899743`}, {2.483949015776244, 1.5965283884405133`}, {
       2.4947111505370025`, 1.6195613321396465`}, {2.5363992537438307`, 
       1.704857315415098}}, 0.1], InsetBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {2.412892192763844, 1.2268752556337494`},
       
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], 
      ArrowBox[{{2.3502937127268395`, 0.8301000022170418}, {2.231240071805297,
        0.7981176473636906}, {2.1992141471142874`, 0.7901123577119905}, {
       2.166927729333291, 0.7832325509129047}, {2.1344203583995633`, 
       0.777486652401891}, {2.101731844843212, 0.7728816989604267}, {
       2.0689022210327646`, 0.7694233300983324}, {2.035971692149063, 
       0.7671157811472806}, {2.0029805869475212`, 0.7659618780739476}, {
       1.5385445050407105`, 0.757850392867624}, {1.5055332264622365`, 
       0.7578515488128366}, {1.4725422021532981`, 0.7590077623609527}, {
       1.439611834955736, 0.761317617541596}, {1.4067824534269542`, 
       0.7647782855637393}, {1.3740942624510817`, 0.769385528280017}, {
       1.3415872940015938`, 0.7751337033770216}, {1.3093013581156907`, 
       0.782015771285228}, {1.1892035079598116`, 0.8098212892012325}}, 0.1], 
      InsetBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {1.8300203209562687`, 0.7933019439921065},
       
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      ArrowBox[{{2.3502937127268395`, 0.8301000022170418}, {2.619790262919107,
        0.05157036380392277}}, 0.1], InsetBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.4850419878229735`, 0.4408351830104823},
       
       Background->GrayLevel[1]]}}, {
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{2.9157490156441668`, 0.921214030135123}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["11", {2.9157490156441668`, 0.921214030135123}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{2.619790262919107, 0.05157036380392277}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["10", {2.619790262919107, 0.05157036380392277}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{1.7260532863903684`, 0.9148143915310374}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["6", {1.7260532863903684`, 0.9148143915310374}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{1.5004701639287972`, 0.}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["5", {1.5004701639287972`, 0.}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{0.5654035556618213, 0.8956763522729346}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["1", {0.5654035556618213, 0.8956763522729346}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{0.37937330797355995`, 0.01984278510122095}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["4", {0.37937330797355995`, 0.01984278510122095}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{0.29576303003206283`, 1.6742565004194954`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["2", {0.29576303003206283`, 1.6742565004194954`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{0., 0.8032158129367948}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["3", {0., 0.8032158129367948}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{1.4153732528813605`, 1.7253916835552001`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["7", {1.4153732528813605`, 1.7253916835552001`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{1.1892035079598116`, 0.8098212892012325}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["8", {1.1892035079598116`, 0.8098212892012325}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{2.5363992537438307`, 1.704857315415098}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["12", {2.5363992537438307`, 1.704857315415098}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      DiskBox[{2.3502937127268395`, 0.8301000022170418}, 0.1], 
      {GrayLevel[0], 
       StyleBox[InsetBox["9", {2.3502937127268395`, 0.8301000022170418}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}}},
   Annotation[#, 
    VertexCoordinateRules -> {{2.9157490156441668`, 0.921214030135123}, {
     2.619790262919107, 0.05157036380392277}, {1.7260532863903684`, 
     0.9148143915310374}, {1.5004701639287972`, 0.}, {0.5654035556618213, 
     0.8956763522729346}, {0.37937330797355995`, 0.01984278510122095}, {
     0.29576303003206283`, 1.6742565004194954`}, {0., 0.8032158129367948}, {
     1.4153732528813605`, 1.7253916835552001`}, {1.1892035079598116`, 
     0.8098212892012325}, {2.5363992537438307`, 1.704857315415098}, {
     2.3502937127268395`, 0.8301000022170418}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->700,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.5930887822785883`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"plot", " ", "graph", " ", "in", " ", "3", "D"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"GraphPlot3D", "[", 
   RowBox[{"MathematicaGraph", ",", " ", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
    RowBox[{"VertexCoordinateRules", "\[Rule]", "Auto"}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"VertexRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"White", ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Sphere", "[", 
          RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{"#2", ",", "#1"}], "]"}], ",", "Large", ",", "Italic", 
           ",", 
           RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], 
        "}"}], "&"}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"HashString", "[", "#3", "]"}], ",", "1", ",", "0.7"}], 
          "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"#1", ",", "0.1"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"#3", "=!=", "None"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"#3", ",", "Medium", ",", 
               RowBox[{"Hue", "[", 
                RowBox[{
                 RowBox[{"HashString", "[", "#3", "]"}], ",", "1", ",", 
                 "0.7"}], "]"}], ",", "Italic", ",", 
               RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
              "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "#1", "]"}], ">", "2"}], ",", 
               RowBox[{
                RowBox[{"Mean", "[", "#1", "]"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                   RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "*", "0.7"}]}], 
               ",", 
               RowBox[{"Mean", "[", "#1", "]"}]}], "]"}], ",", 
             RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ImageSize", "\[Rule]", "700"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.569607469868877*^9, 3.569607481417492*^9}, {
   3.56960815303469*^9, 3.569608212585122*^9}, {3.5696082440098677`*^9, 
   3.569608248801093*^9}, {3.569608280216692*^9, 3.569608376791531*^9}, {
   3.569608410003973*^9, 3.569608599956274*^9}, 3.569608941585931*^9, {
   3.569609206248687*^9, 3.569609267530383*^9}, {3.569618948865366*^9, 
   3.569618951639709*^9}, {3.569619003368388*^9, 3.569619003781415*^9}, {
   3.569619361980508*^9, 3.569619362331675*^9}, {3.569619509916873*^9, 
   3.569619546616232*^9}, {3.569621106445619*^9, 3.569621153468734*^9}, {
   3.587496891552887*^9, 3.5874969520621243`*^9}, {3.587497008308509*^9, 
   3.587497060788553*^9}, 3.587497094142061*^9, {3.587497130061305*^9, 
   3.587497170046094*^9}, {3.588042550731573*^9, 3.5880426497167263`*^9}, {
   3.58807893446441*^9, 3.588078949695486*^9}, {3.591026839677394*^9, 
   3.5910268425241613`*^9}, {3.591026886798623*^9, 3.591026910410639*^9}, {
   3.591026966870488*^9, 3.591026980460433*^9}, {3.5910270136059723`*^9, 
   3.591027013942484*^9}, {3.591027080354863*^9, 3.5910270894784927`*^9}, {
   3.591027351758572*^9, 3.5910273549353933`*^9}, {3.591919065489099*^9, 
   3.591919074884701*^9}, 3.591921266564002*^9, {3.591921309404653*^9, 
   3.591921322895782*^9}, {3.591921803210824*^9, 3.59192180348807*^9}, {
   3.591922390321838*^9, 3.59192243140271*^9}, {3.591922887508726*^9, 
   3.5919229862478533`*^9}, {3.5919230561887007`*^9, 3.591923074637396*^9}, {
   3.591923119562149*^9, 3.5919231697233458`*^9}, {3.591923267241754*^9, 
   3.5919232982758923`*^9}, {3.5919233703168364`*^9, 
   3.5919234623768473`*^9}, {3.5919234967812033`*^9, 
   3.5919236636758957`*^9}, {3.591923701521368*^9, 3.591923824481277*^9}, {
   3.591923857713616*^9, 3.5919239480553627`*^9}, {3.59192402836586*^9, 
   3.591924062163271*^9}, {3.591924144865118*^9, 3.591924145078718*^9}, {
   3.5919241821475687`*^9, 3.591924206894228*^9}, {3.5919244113802233`*^9, 
   3.591924429227065*^9}, {3.591924999883565*^9, 3.591925009069581*^9}, 
   3.591927221707563*^9, {3.591927333753249*^9, 3.591927342450004*^9}, 
   3.5919291732699137`*^9, {3.5919292360239067`*^9, 3.5919292419318943`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAOonK7E8YD/M/zu+13TzP0Zkjmeq
Puw/oOpr2fZVmj8JqKSP3gvyP2N2g+PEV+0/UByeCOgxoD9v+Xmvy6rxP4wR
0M9co+0/gGn4ibfDoj8kSorD/UjxP75fJ6GF7+0/wGNFtZvfpD/fy451k+bw
Pyz/BXcnPO4/8M8nR+uEpj/b5Uegq4PwP6C+90oqie4/sKd1KSKzpz+a19BF
ZSDwP2HdH/h11u4/EEqhnOFpqD8GCs4Lv3nvP6TTykLyI+8/EO1tVfCoqD9g
8E8oc7LuPwxEB+CGce8/cM/GhZrVqD8zOkToor3jPzE3VMCr2vE/cN8+v+Sc
qD/RmYYcVfbiP2Vv8g52AfI/YK3mQHzspz/0co3kQy/iP4bqRzQ0KPI/EHgp
WZjEpj9d4V6prWjhP+f52wraTvI/MJICzJUlpT+MGXKt0KLgP6HZ1HRbdfI/
sBLotfYPoz9W+VTy1bvfP1gpxF+sm/I/gC4AY2KEoD9xw8mOdDTeP3HQb8jA
wfI/oA1cNUoHmz+5WTrk96/cPwUelr6M5/I/AEoLuUg3Zz83cLW4TQvXPxKn
kPwZdPM/963i5A==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.019532314188796022`, 
       0.8497688537775805, 1.025227284381246},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAEoLuUg3Zz83cLW4TQvXPxKnkPwZ
dPM/IITlnHdnlb9KzxJzMq/cPwQelr6M5/I/INK11FB1m7+xib3zfTPeP3DQ
b8jAwfI/QDa163dMoL/cRnyjtbrfP1cpxF+sm/I/gDACF1xoor/5H7VtL6Lg
P6DZ1HRbdfI/sJzkqKsNpL8A7EIY/2fhP+b52wraTvI/cHQyi+I7pb+CCDHN
iy7iP4XqRzQ0KPI/0BZe/qHypb+wrQRNl/XiP2Rv8g52AfI/0Lkqt7Axpr9W
x4Iw47zjPzA3VMCr2vE/MJyD51pepr+DfY5ws7HuPwpEB+CGce8/MKz7IKUl
pr/lHUw8AXnvP6LTykLyI+8/IHqjojx1pb9hoiI6CSDwP1/dH/h11u4/0ETm
ulhNpL8t67lXVIPwP56+90oqie4/8F6/LVauor8VT7DVQubwPyr/BXcnPO4/
cN+kF7eYoL+GHdSvtUjxP7xfJ6GF7+0/gPZ5iUUanL/+6rYIjqrxP4sR0M9c
o+0/IKfV+MoYlr9sxVozrQvyP2J2g+PEV+0/AOonK7E8YD/M/zu+13TzP0Zk
jmeqPuw/FMXjfw==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {-0.014716270269086888`, 
       0.7263221243514705, 1.0732674254351733`},
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAEoLuUg3Zz83cLW4TQvXPxKnkPwZ
dPM/57HpH2+ZvT/FlAFMoMPYP+exN1cyf/M/DmbTz2Ouwj/14Mz92zDZPw0B
4ygugvM/3DaDjxiXxj+jg9HroozZP1yZnbIvhfM/OrDsEpyFyj/+7hVQ2NbZ
P1TNJAM2iPM/w1jZy7J4zj9lZ6rmZA/aP02StidAi/M/aBNx3o830T+HR/T0
NjbaPxGcXSxNjvM/aHZobtIz0z8I6jxPQkvaP9DYPRxckfM/990qvYEw1T/8
eoJcgE7aP2s14QFslPM/orhJA/+S6D8C/9Cg1v7ZP4xI9wiEv/M/NoiwTD2R
6T+WAthcRvDZPyelmu6TwvM/DgCxghKP6j8y63xY7M/ZP+bhet6ixfM/AX/Q
EC+M6z9dpUW40p3ZP6rrIeOvyPM/tMF4nEOI7D8+jDMxCVrZP6Owswe6y/M/
r8fYHQGD7T8RxtYDpQTZP5vkOljAzvM/TMWr+Bh87j+1k6T1wJ3YP+p89eHB
0fM/AV7eFD1z7z8JqpJIfSXYPxDMoLO91PM/veE9UgmF8T9FunljJUTWP+TW
Rw7W3/M/Bifi2A==
       "], 0.1], Text3DBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {0.4704014797920918, 
       0.3753034964923519, 1.2271001561212531`},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAApxT32SGF8T/YvmR4geDzP14v0mUF
nuw/LA1dh1Pq8T8eqeDMN2fyPzfDEJt+w+0/khakEYYD8j+Ojz1NwgHyP3Gi
NB1qEu4/Fl5UieUY8j/f2nNbipvxP2ikrOTsYe4/FQ0NO2sq8j/juIMDsDTx
P3fp+QPuse4/ReZ6qBE48j/ZZFeEU83wP4ZYAWZUAu8/kSwRitRB8j+fIKdF
lWXwP0+56NUGU+8/Rxth0LBH8j8dxqCbK/vvP5bC/Qbso+8/94MPpaRJ8j9V
1UZv6yrvPxqipJzq9O8/ANYr1ZpJ8j+7LqjvJLjjP4id3nJjNPI//paEm6VH
8j/PJ7bQ5OfiP0oNsr3iXPI/Vbyr8MdB8j9ONjwJ5hfiP+6RPFZVhfI/vjts
qwM48j+5PM7OaUjhP1JCMI6urfI/Dluk21sq8j+TKxIusXngP9n5M7/h1fI/
bu9PydQY8j/MWrbs+VffP2Gc2k7i/fI/SsIw83MD8j8nGbBKG7/dP12dlrKj
JfM/1ocVDUDq8T9dY7alRincP/mMqHMZTfM/veE9UgmF8T9FunljJUTWP+TW
Rw7W3/M/DOPgOQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.112948436449741, 0.8595871075601862,
        1.0431415124238097`},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAApxT32SGF8T/YvmR4geDzP14v0mUF
nuw/z38FlhFV8z8mPC9ai0j0P1OX1Cnhk+w/o8b648XR8z/nWVLrOWL0P7cN
B/4mkew/n8MorExP9D8Xb0peh3f0P/YV/5dnjuw/IFfgk37N9D9Ky1wFbYj0
PzoNQ9Sji+w/vSHMCjRM9T8ACmOU5ZT0P+m6t5DciOw/g+JXV0XL9T96PnQi
7Zz0P5a/WqwShuw/gMMko4pK9j8kwB4rgaD0P+Or/AZHg+w/Ka2GB9zJ9j9V
NTKPoJ/0P0bV+oB6gOw/AjtOQuHI/T/yZWgw73P0P9EHMaUWWew/4UPO1BZI
/j+CzU82mm70PzQxLx9KVuw/r1CuswjH/j8Ua/uJ0mT0P4Ed0Xl+U+w/ZPhp
Eo9F/z8CnVo8m1b0Py4idJW0UOw/xcAwRoLD/z/rxWXC+EP0P93P6FHtTew/
+OQqaV0gAEASl7jz8Cz0PyHHLI4pS+w/aYFYuoheAEC+K70IixH0P2DPJChq
SOw/eQL3mC+cAECEiGiYz/HzP8RFV/yvRew/pvt0dleBAUBgOGwLRnPzP7it
WcCLO+w/oDPbEQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.5632726726783197`, 
       1.2513536994424344`, 0.8891458218527809},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      Arrow3DBox[{{1.0950029863609332`, 1.242310972487692, 
       0.8942896832172484}, {0.0019820652316842047`, 1.2160260611562874`, 
       0.8826496145803808}}, 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.5484925257963087, 
       1.2291685168219897`, 0.8884696488988146},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAveE9UgmF8T9FunljJUTWP+TWRw7W
3/M/Ti6OgshQ8z+h9dAumSXYP5dxcvp61PM/ZKsiMnHM8z/BIn+34p3YPwJf
XDdt0fM/2xy9yRNJ9D+b2RRmyQTZP96F0plZzvM/48M4NonG9D/Dl8n3LFrZ
P/10whhBy/M/YalXIqpE9T9B6Vin8p3ZP9UZoqwkyPM/gXUXA0/D9T/f/2Y1
BdDZPyfbIU8FxfM/oSIXJFBC9j/oAirvVPDZPyBR3vrjwfM/fqgJtIXB9j/a
AFaz1/7ZP2CzEavBvvM/BdrmWh/A/T9kbLL/rE3aP1rZHnymkvM/O+oOeGE/
/j9uY6ZBXkraP5o7UiyEj/M/FNS/PIi+/j/aYdkKPzXaP5OxDthijPM/LqTf
y2s9/z8JTIf6VQ7aP+VyjnpDifM/D5RmXeS7/z/hYZ1Dr9XZP7wXbg4nhvM/
Ru9rJeUcAECNKueoXIvZP9wGXo0Og/M/DQjYDXtbAEBT+Xx3dS/ZP7gt1O/6
f/M/mXbiSKCZAEB2ynV/FsLYPyMbviztfPM/ym6zucSAAUAgx2CiOgnXP9S1
6BiScfM/q0HeDA==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.562415402876969, 
       0.37351102753346965`, 1.2306280429598968`},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAveE9UgmF8T9FunljJUTWP+TWRw7W
3/M/OenXpNcf8T8xEYoRTCncP/iMqHMZTfM/1N+QGqUG8T9wdxYQIr/dP1yd
lrKjJfM/T5jgokXx8D8ySj3XAVjfP2Cc2k7i/fI/UOkn8b/f8D8O6X6btXng
P9j5M7/h1fI/IBC6gxnS8D8jkdeZbkjhP1FCMI6urfI/1MkjolbI8D+VGTgX
6xfiP+2RPFZVhfI/HtvTW3rC8D+4lOUG6ufiP0kNsr3iXPI/bnIlh4bA8D+A
hT8zKrjjP4ed3nJjNPI/ZSAJV5DA8D8aLN6y8CrvPxiipJzq9O8/Z1+wkIXC
8D8GM9DRMPvvP5TC/Qbso+8/EDqJO2PI8D9EEqXMl2XwP0256NUGU+8/p7rI
gCfS8D8OD9zpVc3wP4RYAWZUAu8/V5uQUM/f8D+iFzo6sjTxP3Xp+QPuse4/
9gblYlbx8D+3lhVWjJvxP2akrOTsYe4/GzQEObcG8T8hJ5f+wwHyP2+iNB1q
Eu4/j24fH+sf8T+TlNUnOWfyPzXDEJt+w+0/pxT32SGF8T/YvmR4geDzP14v
0mUFnuw/QBfgcw==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {1.077034142479343, 0.7306331696837101,
        1.0932956696716152`},
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAveE9UgmF8T9FunljJUTWP+TWRw7W
3/M/il+F+MXp8T8OKjRL3/fTP0+br+KhZvI/MAr9INkC8j+HestAs1nTP3r4
sCcyAfI/+nPrJxkY8j98dDmfZLrSP94Juf7/mvE/6CrLY38p8j/SnmRYJRrS
P5u793ErNPE/2+4lYAY38j9Ck6WpJ3nRP4RJhr7UzPA/2IBK36lA8j8aygYM
ntfQPyjKS0ocZfA/CQSh22ZG8j/srnEkuzXQP/XdqTNF+u8/8IWdiDtI8j9k
6JtnYyfPP35RRIwQKu8/QQc5enxG8j+Zc9v8iq66P3zW38vrt+M/4OLrRGhE
8j+sIwRKlia4PwVKeiS35+I/xdEv1Gs+8j825HTLnZ+1P6mTjMPDF+I/Ypx1
CIk08j+QZqxWbBqzP/GUF9tSSOE/LHot+8Im8j+fQYAyzJewP8OwNHSleeA/
tlDO/R0V8j+WqmSvDTGsP34oZLX4V98/uh97mJ//8T8sk41jyTqnPw5uhBEw
v90/zgZHiE7m8T/K7VzAWU6iP7jiiSVxKdw/CaVCrquA8T8AAAAAAAAAAGr0
KHegRNY/warY5A==
       "], 0.1], Text3DBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {1.1124758726652297`, 
       0.19898044343453408`, 0.8595066120906553},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAveE9UgmF8T9FunljJUTWP+TWRw7W
3/M/iZg3CRxu7z+4lS3Q0ovUPxDMoLO91PM/QvU/+bB17j+KSWIelx7UP+p8
9eHB0fM/DgFUyYN77T/apl0w0MLTP5vkOljAzvM/t6J56OJ/7D9+OxnMmnjT
P6Owswe6y/M/lXg+Oh2D6z8Yw4Q1DkDTP6rrIeOvyPM/EkX8/YGF6j/24jon
PBnTP+bhet6ixfM/kZMAtmCH6T92QPLMMATTPyelmu6TwvM/yl+fDgmJ6D+C
r6y/8gDTP4xI9wiEv/M/RCzW05Uc1T96K157nFDTP2s14QFslPM/Ho0IQRkg
0z/mJ1e/LF/TP9DYPRxckfM/bJ0H1W4k0T9KP7LDhn/TPxGcXSxNjvM/Cz+R
cWtUzj8gheljoLHTP02StidAi/M/QDTwQhlkyj9AnvvqafXTP1TNJAM2iPM/
WRxwPSN5xj9sZFgYzkrUP1yZnbIvhfM/3yUk0sOUwj/GloomsrHUPw0B4ygu
gvM/HYazwmZwvT90gJzT9SnVP+exN1cyf/M/AEoLuUg3Zz83cLW4TQvXPxKn
kPwZdPM/TlTYwQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.6274120914640837, 
       0.33267072523661556`, 1.2308924379929613`},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAApvt0dleBAUBgOGwLRnPzP7itWcCL
O+w/saXRuLKxAUCsJS3FRwryP/8O6wlzVO0/qKCs5Ly9AUBsIpYtNKnxP6xS
sDH9n+0/PwUMp/LHAUCoZLPVZkfxPxyaHCQY7O0/jAJ9zFDQAUCksw9n/uTw
PybGBQWsOO4/SytotdTWAUDRLtW7GYLwPzXRV9Kghe4/aQPkVnzbAUCrHyHV
1x7wP/Wvm2ve0u4/pfBYO0beAUD5Kpeir3bvP+C4h5lMIO8/21r2gjHfAUBZ
rkvEca/uP4IzlxXTbe8/tlUP0fbeAUBK3G6oeLvjP/HySW5u2PE/HdIRMgPe
AUAyoohqO/TiP0KwUawx//E/fkPa+DDbAUAtDNtDPS3iP7e0R8PoJfI/GujV
B4HWAUAI3HGXvGbhPxek6Y+HTPI/zFw31/TPAUDhEAKh96DgP5+pkvYBc/I/
mquAdI7HAUD9Ms7CWLjfP6Q/B+dLmfI/xYregVC9AUDU82QWMTHeP1xjPWBZ
v/I/5v9UNT6xAUDx+Kfe8qzcPzIFIHQe5fI/ym6zucSAAUAgx2CiOgnXP9S1
6BiScfM/zxzaFw==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {2.205214967318218, 0.8494727862074454,
        1.0247450217356062`},
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAApvt0dleBAUBgOGwLRnPzP7itWcCL
O+w/E8ZtmF+ZAEAUu6EpPAvzP8RFV/yvRew/qSJzcQVbAEBUnX6YjfHyP2DP
JChqSOw/KiRcDUIcAEAjiIYlQNzyPyHHLI4pS+w/1LQAM1K6/z/vK3R+Wsvy
P93P6FHtTew/N+oUvJw7/z847W3v4b7yPy4idJW0UOw/cSmJb4u8/j+/uFxh
2rbyP4Ed0Xl+U+w/dEi8I0Y9/j8WN7JYRrPyPzQxLx9KVuw/y15av/S9/T/k
wZ70JrTyP9EHMaUWWew/8tCShO++9j9GkWhT2N/yP0bV+oB6gOw/E8gS8rk/
9j+4KYFNLeXyP+Or/AZHg+w/RbsyE8jA9T8mjNX59O7yP5a/WqwShuw/kBN3
tEFC9T82WnZHLP3yP+m6t5DciOw/L0uwgE7E9D9OMWvBzg/zPzoNQ9Sji+w/
BEKL9BVH9D8mYBiQ1ibzP/YV/5dnjuw/IgkwUr/K8z96yxN7PELzP7cNB/4m
kew/AQfzlHFP8z+0bmjr92HzP1OX1Cnhk+w/pxT32SGF8T/YvmR4geDzP14v
0mUFnuw/4w3Zxg==
       "], 0.1], Text3DBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {1.7198854168368316`, 
       1.2066002446754105`, 0.887412648447324},
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAApvt0dleBAUBgOGwLRnPzP7itWcCL
O+w/EuqhsduxAUDao9kt4+byP0iroaPDaek/DDov6PC9AUDSmPzeIcHyP9Qb
qjuqp+g/vIGF1jHIAUCBzZy3FpvyP4RP58gc5Oc/HU2xRZvQAUBxJBWlzXTy
P9VUSJpYH+c/4DaRkirXAUDRDCqoUk7yP8iLJ2CbWeY//JGprt3bAUDqJ0bR
sSfyP7OI8xgjk+U/7njJILPeAUCZBrI89wDyP4V8v/0tzOQ/2Q6BBarfAUBW
LsgOL9rxP2I6wW76BOQ/5cr7FxPgAUBRIHMbtXDvP/Pr6wMcI9I/honjISvf
AUCw8C/eISPvP65n7+W0lNA/poW0mWTcAUDnYqARpNXuP6aeDl+VDc4/ZKIx
XsDXAUDdzy4BVIjuP1CSPkK088o/g7rh4z/RAUC66e7pSTvuPxpuu1m/3Mc/
otWaNOXIAUD9WwTzne7tP2CDP5+uycQ/+Y3e7rK+AUBMTBAmaKLtPyFSNNR4
u8E/6NkHRayyAUCoG6hnwFbtP6AorGgmZr0/xNGnJF6CAUDeWY+RZT3sPwBV
sAuWX5s/fpXa2Q==
       "], 0.1], Text3DBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {2.2055474706867026`, 
       1.0731113459549282`, 0.5161759847047587},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAym6zucSAAUAgx2CiOgnXP9S16BiS
cfM/wMRWd2lQAUD0EV27M63cPzEFIHQe5fI/ysl7S19EAUD1HrkZgjHeP1tj
PWBZv/I/MmUciSk6AUADFkR5t7jfP6M/B+dLmfI/5WerY8sxAUALbemZLKHg
P56pkvYBc/I/Jj/AekcrAUCxdl7w9WbhPxak6Y+HTPI/CGdE2Z8mAUD8lMa9
eS3iP7a0R8PoJfI/zHnP9NUjAUBZqXHFefTiP0GwUawx//E/lg8yreoiAUD5
Jb2jt7vjP/DySW5u2PE/uxQZXyUjAUAI+Jm/sK/uP4AzlxXTbe8/VJgW/hgk
AUAgMoD97XbvP964h5lMIO8/8yZON+smAUAT5BYS9h7wP/Ovm2ve0u4/V4JS
KJsrAUAkfEtoNoLwPzPRV9Kghe4/pg3xWCcyAUC4YYPjGOXwPyTGBQWsOO4/
2L6nu406AUBq3VCDfkfxPxqaHCQY7O0/q99JrstEAUA0LWtuSKnxP6pSsDH9
n+0/i2rT+t1QAUDta1r8VwryP/4O6wlzVO0/pvt0dleBAUBgOGwLRnPzP7it
WcCLO+w/07fOKQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {2.170815359747623, 0.7261084813328786,
        1.072750985215793},
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAym6zucSAAUAgx2CiOgnXP9S16BiS
cfM/gkiLIeWaAEDGiwnXxifVPyMbviztfPM/9gnByRBdAECkXltOfa/UP7gt
1O/6f/M/PNHzfb8eAEDKp8WflkjUP9wGXo0Og/M/b/trjwnA/z+k6RAOM/PT
P70Xbg4nhvM/8RVNo+hB/z8mmIFeba/TP+VyjnpDifM/0UmNwkPD/j+GgXPQ
Wn3TP5OxDthijPM/sZyNoUJE/j+AfrAWC13TP5o7UiyEj/M/1BabEQ3F/T+M
gIRSiE7TP1rZHnymkvM/TeW9anPG9j8EFSgGs//SP2CzEavBvvM/F9WVTTFH
9j/4HTTEAQPTPyBR3vrjwfM/PuvkiArI9T+QHwH7IBjTPyfbIU8FxfM/JBvF
+SZJ9T9eNVMLCj/TP9UZoqwkyPM/Qys+aK7K9D+GHz3CsHfTP/50whhBy/M/
xuDMeshM9D/cVvNcA8LTP96F0plZzvM/Oa/0qZzP8z8WiF2O6h3UPwJfXDdt
0fM/IdLfM1JT8z/ytmSGSYvUP5dxcvp61PM/veE9UgmF8T9FunljJUTWP+TW
Rw7W3/M/8uPbMQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {1.7204394136028045`, 
       0.3343365731329052, 1.2267466757868217`},
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAym6zucSAAUAgx2CiOgnXP9S16BiS
cfM/6Zu7yj+xAUDhfURLqdfUP6e3ZIKiCPI/oiFQhlK9AUDFjc6So0DUP1yC
hrSSp/E/gr/Z7JDHAUACiUKkeKjTP3/+UNvIRfE/ixkwyPfPAUD33YQ0WA/T
PxZ1Np9j4/A/SqgAdoTWAUAtC3JFcnXSP1xmYNmBgPA/nyGi6DTbAUAjltEW
99rRPxOsA4pCHfA/9EW5pwfeAUCemDUXF0DRP0u8UJ2Jc+8/bt6u0PveAUB5
osvUAqXQP0sL0bBPrO4/JPjlMz7fAUBLZw8c3jzAP4Q1e6+JuOM/quAtelPe
AUChD3+dXA2+P4SE+8JP8eI/jAdfJ4rbAUA+e7jwsKG7P6joRExUKuI/PFsc
G+PWAUDoIDN4eze5Pxh0i63VY+E/aq3Oyl/QAUDMpwUFfs+2P6RW3yESnuA/
WKEvQQLIAUDArzG2eWq0P6GHVFOPst8/RcqlHc29AUAMBxi8LgmyPyx4fu5n
K94/Ki1yk8OxAUC7YG84uFivPwKjBbcop9w/EC+9sWqBAUCAIG8Xk4ybP1Sq
9VxqA9c/1mrMlA==
       "], 0.1], Text3DBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {2.2051897603650152`, 
       0.21744568701178066`, 0.8490887218541802},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAxNGnJF6CAUDeWY+RZT3sPwBVsAuW
X5s/DjVDfq2yAUDNYrrSdmvpP1Kg7pnOPK8/PJoxgLS+AUCKCUqQU6noP4qU
+uyG+rE/ib5dJufIAUCtXERBveXnP670GoMsW7Q/nW9OPkLRAUAIjF838SDn
P92Tsz2Zv7Y/CENhKcPXAUA1h2wlLVvmPyNJ6RsNJ7k/ANec3WfcAUC2Gv8L
r5TlP0qz3CnHkLs/undU5i7fAUAFrP0ltc3kPzF9KL0F/L0/DvacZBfgAUC2
rB7VfQbkP6ptzFgDNMA/lE5yA7bfAUAtP/qvxyXSP9N4ShFin9A/UeNnrr/e
AUDIqnAiW5fQP1yQZk5iOtE/VwlF0+rbAUA8Y8gk2xLOP9aCOfMx1dE/REdK
VTjXAUCbt5qC9/jKP2Bdtnagb9I/VvB2ranQAUAha29DBOLHP7HKQ259CdM/
1fIS6kDIAUBYdXtg+c7EP33y6ZyYotM/EdkJrgC+AUDPd1OZzcDBP4YKcgLC
OtQ/rjAXMOyxAUCluB9N7HC9P57bcurJ0dQ/EC+9sWqBAUCAIG8Xk4ybP1Sq
9VxqA9c/fIbN2g==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {2.2056343552515356`, 
       0.5163693537076566, 0.16916235861127576`},
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAxNGnJF6CAUDeWY+RZT3sPwBVsAuW
X5s/yQQx2uqaAECdCOOQemDrP/fXIpTnjZg/tpHwXLBcAEDQwy8RqynrP9QY
pxHVy5c/yGzH7QQeAEDiyN9wmvvqPykgmJFOCJc/7MgUZfi9/z9NfhghV9bq
P89Wt2CRQ5Y/GYOc3FM//z/ejo3Q7LnqPwgBLi3bfZU/emBr9kPA/j+vSddn
ZKbqPz7RNvNpt5Q/tt1viPBA/j/2oqcGxJvqPwwBr+l78JM/kWvEfYHB/T+j
td4BD5rqP0gIlW5PKZM/7ICTEW7A9j8pBNyyz8DqP2aZNjqNbIA/9bD6XQtB
9j+srnyTBsjqP75PBYhovH0/WKtY8dzB9T9+noEWJ9jqP/cO5mGwoHo/SNst
qwpD9T/815ItLPHqP9BPCXrrhnc/ur4WTrzE9D+4gZsADhPrP7T446sScHQ/
98RUcxlH9D/pcz/wwT3rP0rTYOgdXXE/QyRkfknK8z+zxi+ZOnHrPzrhSdAH
nmw/JYuikHNO8z/tU13YZ63rPyboa7xzjWY/4ljVuguC8T8rnghMR57sPwAA
AAAAAAAAkBzYNA==
       "], 0.1], Text3DBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {1.7201272614512622`, 
       0.8670727751186504, 0.015293007340007509`},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAxNGnJF6CAUDeWY+RZT3sPwBVsAuW
X5s/WuN66dlRAUDrgrRMK1btP8YorGgmZr0/YJPtssRFAUD8mG7qraHtPzVS
NNR4u8E/sEuXxIM7AUCdLy45xO3tP3SDP5+uycQ/T4BrVRozAUC+gT1eVjru
Py5uu1m/3Mc/jJaLCIssAUD/sBNYTIfuP2WSPkK088o/cDtz7NcnAUDNetsF
jtTuP7qeDl+VDc4/flRTegIlAUBuvQMvAyLvP7hn7+W0lNA/lL6blQskAUD1
bdeKk2/vP/3r6wMcI9I/iAIhg6IjAUAnVXpGntnxP2c6wW76BOQ/5kM5eYok
AUD47BvlZwDyP4p8v/0tzOQ/xkdoAVEnAUDds2PLJifyP7eI8xgjk+U/CCvr
PPUrAUBifZzTzk3yP82LJ2CbWeY/6hI7t3UyAUB0cDzfU3TyP9pUSJpYH+c/
y/eBZtA6AUBSt7HaqZryP4lP58gc5Oc/dD8+rAJFAUArvyvBxMDyP9kbqjuq
p+g/hfMUVglRAUB911+gmObyP02roaPDaek/pvt0dleBAUBgOGwLRnPzP7it
WcCLO+w/FbnNZg==
       "], 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.1712637588440886`, 
       1.0250263464172662`, 0.39282462197288875`},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAEC+9sWqBAUCAIG8Xk4ybP1Sq9Vxq
A9c/xsshWBtRAUCtgIO8mnK9P5rbcurJ0dQ/mWYzVhRFAUBhJQNo2sHBP4IK
cgLCOtQ/S0IHsOE6AUDY2BmkM9DEP3ny6ZyYotM/OJEWmIYyAUBrG63LY+PH
P63KQ259CdM/zr0DrQUsAUC2LnkTdPrKP1xdtnagb9I/1CnI+GAnAUCz4C55
bBTOP9KCOfMx1dE/G4kQ8JkkAUC8TZoIKpjQP1iQZk5iOtE/xgrIcbEjAUBZ
TFiqmCbSP894ShFin9A/QrLy0hIkAUBLs01S5gbkP6JtzFgDNMA/hB39Jwkl
AUB+fRKZHM7kPyJ9KL0F/L0/fvcfA94nAUATuhhhE5XlPzuz3CnHkLs/kbka
gZAsAUD8JKRJjFvmPxNJ6RsNJ7k/fxDuKB8zAUAb+G4ZSSHnP86Tsz2Zv7Y/
AA5S7Ic7AUCM9SvSC+bnP5/0GoMsW7Q/xCdbKMhFAUDv9PXDlqnoP3uU+uyG
+rE/KNBNptxRAUDO26agrGvpPzSg7pnOPK8/xNGnJF6CAUDeWY+RZT3sPwBV
sAuWX5s/LeHDVQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {2.1712135555888565`, 
       0.3930288039863112, 0.21715292539705222`},
       Background->GrayLevel[1]]}, 
     {Hue[9900, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAEC+9sWqBAUCAIG8Xk4ybP1Sq9Vxq
A9c/QAoyNgmcAEAAvF5b9o5wv+5J+lfE79Y/mQfYyFJeAEBA+dzBYyyIvxPe
0K976tY/xgrdqhcgAECAzSnc/vKSv6uX7uYo5dY/BsG+vdbC/z/gCrnA/beY
v8rHk6jN39Y/9SXyFcNE/z8AWMl/X2Odv/emp6Jr2tY/WdEt5RvG/j9QKlmq
1nmgv1+NMYUE1dY/2mOM4AhH/j8QZTqd5LOhv3uA0QGaz9Y/Vaz23rHH/T8w
OLMid1+iv45AOMstytY/tchGY9TG9j9Q2C/0+uGnvzFe5gjdfdY/qkX2UGFH
9j+w8/NB3P6nv0MeTdJweNY/3ffwIvrH9T8ACB1KA42nv2AR7U4Gc9Y/zXKC
ysZI9T+gdwG+k4ymv8j3djGfbdY/Yxi2KO/J9D+gqQMD3v2kv/XWiis9aNY/
7GzWAZtL9D8Qf10ZX+GivxQHMO3hYtY/wm718PHN8z/g0+90wDegv6zATSSP
XdY/X9qBWxtR8z8ApUSQrwOav9FUJHxGWNY/CaVCrquA8T8AAAAAAAAAAGr0
KHegRNY/n8bj0w==
       "], 0.1], Text3DBox[
       StyleBox["\<\"c\"\>",
        StripOnInput->False,
        LineColor->Hue[9900, 1, 0.7],
        FrontFaceColor->Hue[9900, 1, 0.7],
        BackFaceColor->Hue[9900, 1, 0.7],
        GraphicsColor->Hue[9900, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9900, 1, 0.7]], {
       1.720442683151828, -0.005084031759176509, 0.3546005315586577},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAEC+9sWqBAUCAIG8Xk4ybP1Sq9Vxq
A9c/8AG1oO9QAUA92plE1FKvPwyjBbcop9w/OHwg5dxEAUCQrSQEgQWyPzZ4
fu5nK94/WN6Wfp46AUCYwFS+LGa0P6uHVFOPst8/UIRAozcyAUDEbEt9rsq2
P6lW3yESnuA/kPVv9aorAUDwt5Y5RjK5Px10i63VY+E/O3zOgvomAUAVjBj0
Mpy7P63oRExUKuI/51e3wyckAUArgojysge+P4mE+8JP8eI/bL/BmjMjAUBf
LRj+ATrAP4k1e6+JuOM/tqWKN/EiAUCBBdDFlKPQP1AL0bBPrO4/L71C8dsj
AUA/9XesrD7RP1C8UJ2Jc+8/T5YRRKUmAUBZmqmXl9nRPxasA4pCHfA/nkJU
UEwrAUDt8Mr1JHTSP15mYNmBgPA/cPChoM8xAUA1T5ZSJA7TPxh1Np9j4/A/
gvxAKi06AUA4TUtmZafTP4L+UNvIRfE/ldPKTWJEAUBkt9EkuD/UP1+ChrSS
p/E/sXD+12tQAUAQzcnM7NbUP6q3ZIKiCPI/ym6zucSAAUAgx2CiOgnXP9S1
6BiScfM/fJ/Lqg==
       "], 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {2.1708772480104264`, 
       0.16939604585031653`, 0.7257219624278994},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAA4ljVuguC8T8rnghMR57sPwAAAAAA
AAAAbrT4cBrn8T+QD5NCs6vpPyYxAqiqWKI/XetnmkMA8j95iZJvyODoP546
++etR6c/FNLSq5kV8j+dGE5wWRToP/xDMQ0mQKw/4PfK9BUn8j+/hH5cpkbn
PwE0/hNCoLA/hEzw+bI08j84FHex73fmP2q7ZWebI7M/WRqpdmw+8j/3pu09
dqjlPyaL/k1VqbU/xpF4Xj9E8j+nTakNe9jkP4sVLFalMLg/vHrz3SlG8j+T
ux1VPwjkPyny/Y7AuLo/zDIfDJ1F8j/bK87TeCvRP8nv0qbgLM8/hnd+iZ5D
8j+eSQ3HBRbPPwzvnSF3ONA/rVrPpLc98j+dSegJItbLP6VRqSNL2tA/pknB
N+oz8j9DlCg/S5jIP5SFT525e9E/4loRVTkm8j9IdzWRhV3FP25nKfKPHNI/
pqaTR6kU8j/mklE01CbCP+/LgrWbvNI/wMfakD//8T84ja4qcuq9PxuNKbqq
W9M//O995wLm8T+xhrcRaZO3P0quKCKL+dM/CaVCrquA8T8AAAAAAAAAAGr0
KHegRNY/MKfSYQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.1120604049705278`, 
       0.5116254437301542, 0.1488864184163889},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAA4ljVuguC8T8rnghMR57sPwAAAAAA
AAAA2vLCT/JQ8z9u77RMMnvtP0zoa7xzjWY/AtlDSmfN8z86NGjMAbLtP2Dh
SdAHnmw/3CKWKL5K9D8oL7hsEuDtP13TYOgdXXE/gDMQn8/I9D++eX+8VQXu
P8j446sScHQ/U3mIJ3RH9T8taQoNwCHuP+RPCXrrhnc/8pu5DYTG9T9brsB1
SDXuPwoP5mGwoHo/th61e9dF9j8VVfDW6D/uP9JPBYhovH0/25BghkbF9j9n
QrnbnUHuP3CZNjqNbIA/gHuR8lnG/T/h87sq3RruP00IlW5PKZM/d0sqprxF
/j9dSRtKphPuPxEBr+l78JM/FFHMEuvE/j+MWRbHhQPuP0PRNvNpt5Q/JCH3
WL1D/z8NIAWwgOrtPw0BLi3bfZU/sj0OtgvC/z9RdvzcnsjtP9RWt2CRQ5Y/
uhtoSNcfAEAhhFjt6p3tPy4gmJFOCJc/FGzgQj9eAEBXMWhEcmrtP9kYpxHV
y5c/pDjBOSqcAEAcpDoFRS7tP/zXIpTnjZg/xNGnJF6CAUDeWY+RZT3sPwBV
sAuWX5s/1ILKmA==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.5627783326013964`, 
       0.909743052060358, 0.011438812254783479`},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      Arrow3DBox[{{1.0942494676760863`, 0.8943211064369668, 0.}, {
       1.0950029863609332`, 1.242310972487692, 0.8942896832172484}}, 0.1], 
      Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.0946262270185096`, 
       1.0683160394623294`, 0.4471448416086242},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      Arrow3DBox[{{1.0942494676760863`, 0.8943211064369668, 0.}, {
       0.0002550999848951463, 0.8827671441054274, 0.027174767348906337`}}, 
       0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.5472522838304907, 
       0.8885441252711972, 0.013587383674453168`},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAACaVCrquA8T8AAAAAAAAAAGr0KHeg
RNY/re5YpW5L8z+Az0auULCfP9FUJHxGWNY/+vMMgNvG8z+Qzi58YtGjP6zA
TSSPXdY/oO0CvFFD9D8Ad8z5yD+nPxQHMO3hYtY/JUL+U6rA9D+wFRRsSCKq
P/XWiis9aNY/Nt3K+70+9T9APJxL+XesP8j3djGfbdY/0jGPLGW99T+QuhA2
IECuP2AR7U4Gc9Y/UZ8wMXg89j9Q9fEoLnqvP0QeTdJweNY/1lbGMs+79j84
ZDVX4BKwPzFe5gjdfdY/djp2rqy8/T9ItPM/ItSyP45AOMstytY/gb3GwB88
/j/4wdXmkuKyP3yA0QGaz9Y/TgvM7oa7/j8gTOpqpqmyP1+NMYUE1dY/XpA6
R7o6/z/wg9ykbimyP/emp6Jr2tY/x+oG6ZG5/z/wnF3HE2KxP8rHk6jN39Y/
H0vzB/MbAECoh4pS1FOwP6uX7uYo5dY/NMpjkMdaAEAgZKcACv6tPxPe0K97
6tY/ZZQd2zKZAEDA4tlTIciqP+5J+lfE79Y/EC+9sWqBAUCAIG8Xk4ybP1Sq
9VxqA9c/yhrZTg==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {1.5616628287904148`, 
       0.03198746871110304, 0.35292158142891444`},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAACaVCrquA8T8AAAAAAAAAAGr0KHeg
RNY/fUkf+Jwb8T/bdKxLoJS3P0auKCKL+dM/jxKwznMC8T+SpbDj9uu9PxeN
KbqqW9M/1ytFvR3t8D89FuputyfCP+vLgrWbvNI/DAZNdKHb8D+xZSi+g17F
P2pnKfKPHNI/aLEnbwTO8D/PJ0ZqXpnIP5CFT525e9E/kuNu8krE8D/Q3Gs4
RNfLP6FRqSNL2tA/JmyfCni+8D8OQn35MBfPPwjvnSF3ONA/MIMki4288D8w
xdXtDyzRP8Hv0qbgLM8/IMv4XBq98D8+iCHiigjkPxny/Y7AuLo/ZoaZ3xi/
8D/FS0XaxdjkP3sVLFalMLg/PqNIxP/E8D/Ei47JvqjlPxaL/k1VqbU/RLRW
Mc3O8D8beT58NHjmP1q7ZWebI7M/CqMGFH7c8D9aQLvn5UbnP/Az/hNCoLA/
RleEIQ7u8D9yOfQ+khToP9xDMQ0mQKw/LDY92HcD8T+EzLIG+eDoP346++et
R6c/8A2agbQc8T9VrdEp2qvpPwgxAqiqWKI/4ljVuguC8T8rnghMR57sPwAA
AAAAAAAA19zSpg==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {1.0761027901839837`, 
       0.38269566270681254`, 0.19905223015764623`},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAACaVCrquA8T8AAAAAAAAAAGr0KHeg
RNY/Pif7B+8b8T+8gSzCMGKiP8HiiSVxKdw/mHyD39sC8T/4/XEVkVOnPxhu
hBEwv90/zhKV2Jvt8D9QLgIiBk6sP4goZLX4V98/4Fu1nDXc8D/QbVQsAKiw
P8iwNHSleeA/7JdaoK7O8D8QnFDn9iuzP/aUF9tSSOE/8AU2IQvF8D+xwMtd
HbK1P66TjMPDF+I/voLfJE6/8D9qLSD8qDm4PwpKeiS35+I/2ADjd3m98D9R
GK++zsG6P4HW38vrt+M/hn9Hhji/8D/AuoVIBTHPP4NRRIwQKu8/5qOUu0zB
8D9bsfjQfzrQP/rdqTNF+u8/ArVQLEnH8D85gZzwPdzQPyvKS0ocZfA/ZOoK
+CvR8D+ioM5Nin3RP4dJhr7UzPA/mgxTBfLe8D/eqdlWMh7SP56793ErNPE/
EDayApfw8D/zJI2tA77SP+AJuf7/mvE/DGcFaBUG8T/gBwg3zFzTP3z4sCcy
AfI/+H85eGYf8T+MHG4rWvrTP1Kbr+KhZvI/veE9UgmF8T9FunljJUTWP+TW
Rw7W3/M/UFzaDw==
       "], 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {1.0764174473813461`, 
       0.14892886132167005`, 0.7305795353615562},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAACaVCrquA8T8AAAAAAAAAAGr0KHeg
RNY/DxGgdbdg7z9A1S9rqvmZv1eUZ1dvWdY/WjuRqBtn7j9gG/cdazGgvyex
+NMHX9Y/cQSaoNtr7T8A3JetwNmivwJlRgqrZNY/yyPrIkZv7D9QYT6ZAPWk
v9hP2TVXatY/kq/CX6px6z+A8AvRgYKmvwsZa48KcNY/Hn6Y2Vdz6j+wsH+1
x4Gnv4MrdU3DddY/CcAwTJ506T9Q14g+gvKnv3MmwKR/e9Y/j6Ock8116D9A
8Z0UjtSnv8PV88g9gdY/gKXOdojq1D+A7/nfQUOiv+SsV4sP0tY/XQ33dVjt
0j9QZi1nqJahvzRci6/N19Y/peyIiDnx0D9wyzu8n1ugvyRX1gaK3dY/jWIA
+JXtzT/ApilHFSWdv5xp4MRC49Y/BqyULFf9yT8ApsjU8HeYv88ych726NY/
Wa/+x/ISxj/g6klzSbGSv6UdBUqi7tY/TIqpDaMvwj9A+Spt3aWHv4DRUoBF
9NY/asxpEUCpvD8AunwZP/huv1Du4/zd+dY/AAAAAAAAAACACDQHfdabPzuO
It2sDtc/N3rcUQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {
       0.6253084576858379, -0.008835642196958989, 0.35321565901510577`},
       Background->GrayLevel[1]]}, 
     {Hue[9506, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAECjF963MD/wUL3hoD/sP6DrKMSz
05s/oMmWJrxwmD8UlihRwG3pP0yzlqYpeq8/oPLqTeR1nj/ebSmhoKvoP2bI
cPWlGbI/0JNwJG7IoT/wTWFwDejnP9LdROe9erQ/EMJ1KwXgoz/MI4wPRCPn
PzBqSLOd37Y/YMngUQ+BpT93WaUwgl3mPyb5jDSFR7k/sOFU2Amrpj+PNZDT
BZflPxM18lKzsbs/gG06U5ddpz+zzqcyDdDkPxyJrz9mHb4/ENYIyH+Ypz9N
qjyv1gjkP5aDC9ntRMA/UCAp4x+Lpz8ZlKljiSrSPy5b3yxxqdA/gKXz2VBO
pz+tiDyBHZzQP7I6eYmORNE/wKIzY92Zpj+ijJdYXxzOP7WPqER739E/wHbO
Ef5tpT+83MpMeQLLP7DeQcwGetI/oO5Y6RDLoz/+u+vEgevHP20Ck6wAFNM/
wMOdQJmxoT+x9oa7cNjEP4Xlk584rdM/gNPgMH9Enj8Ryh7yPMrBP+DqCJx+
RdQ/YCuyzaI7mD+7z5xHt4O9P5BGkuSi3NQ/AAAAAAAAAACACDQHfdabPzuO
It2sDtc/dVjYKQ==
       "], 0.1], Text3DBox[
       StyleBox["\<\"a\"\>",
        StripOnInput->False,
        LineColor->Hue[9506, 1, 0.7],
        FrontFaceColor->Hue[9506, 1, 0.7],
        BackFaceColor->Hue[9506, 1, 0.7],
        GraphicsColor->Hue[9506, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9506, 1, 0.7]], {0.01732435725731258, 
       0.5166500576485861, 0.1697098421891881},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      Arrow3DBox[{{0.0002550999848951463, 0.8827671441054274, 
       0.027174767348906337`}, {0.0019820652316842047`, 1.2160260611562874`, 
       0.8826496145803808}}, 0.1], Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.0011185826082896755`, 
       1.0493966026308574`, 0.4549121909646436},
       Background->GrayLevel[1]]}, 
     {Hue[9702, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAAAAAAAAAACACDQHfdabPzuOIt2s
Dtc/oDw4rtwtmL8J2XLGo4S9P4xGkuSi3NQ/oGWM1QQznr9dDTaj0MrBP9zq
CJx+RdQ/UE1BaP6mob8XjVZmHdnEP4Hlk584rdM/kHtGb5W+o7+qNavpQuzH
P2kCk6wAFNM/4IKxlZ9fpb/8XkZlSgPLP6zeQcwGetI/MJslHJqJpr+Z7prZ
Ox3OP7GPqER739E/ACcLlyc8p78FRZ4uj5zQP646eYmORNE/kI/ZCxB3p7/P
jXQ1/CrSPypb3yxxqdA/0Nn5JrBpp78oJyIYEAnkP46DC9ntRMA/AF/EHeEs
p7/erFgJRtDkPw2Jrz9mHb4/QFwEp214pr8MDtHzPJflPwQ18lKzsbs/QDCf
VY5Mpb8GOsR2tl3mPxb5jDSFR7k/IKgpLaGpo781ArxYdCPnPyFqSLOd37Y/
QH1uhCmQob+IMxWbOOjnP8LdROe9erQ/gEaCuJ8Bnr+xPm+NxavoP1bIcPWl
GbI/YJ5TVcP4l789VwPh3W3pPy6zlqYpeq8/AECjF963MD/wUL3hoD/sP6Dr
KMSz05s/5mPRhw==
       "], 0.1], Text3DBox[
       StyleBox["\<\"b\"\>",
        StripOnInput->False,
        LineColor->Hue[9702, 1, 0.7],
        FrontFaceColor->Hue[9702, 1, 0.7],
        BackFaceColor->Hue[9702, 1, 0.7],
        GraphicsColor->Hue[9702, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[9702, 1, 0.7]], {-0.017069257272417433`, 
       0.39330248223611897`, 0.21773563129082518`},
       Background->GrayLevel[1]]}, 
     {Hue[10100, 1, 0.7], Arrow3DBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABIAAAADAAAAAAAAAAAAAACACDQHfdabPzuOIt2s
Dtc/I8gpN/8EvT/g7jG5E+iqP1Du4/zd+dY/5TrQz+5owj+gH5GhqRyuP4DR
UoBF9NY/iBat7+5Vxj8g8JiYf2KwP6UdBUqi7tY/IZlo5kRIyj/IMmyOH3Cx
P88ych726NY/BWoK87M+zj9g+lIq4DayP5xp4MRC49Y/65fZBf8b0T942owc
g7ayPyRX1gaK3dY/FRSpIHIZ0z/IbRFh4O6yPzRci6/N19Y/CU3RkRMX1T/A
+htM5t+yP+SsV4sP0tY/U/cdIROM6D/g+ckxQBewP8PV88g9gdY/ZcOJIauK
6T+Qasfq5oGvP3MmwKR/e9Y/wdNAmLqI6j+wz9U/3kauP4MrdU3DddY/cDGF
3vGF6z+g1y4nyX2sPwsZa48KcNY/Eh9gkQGC7D9AV/7tNieqP9hP2TVXatY/
PZ6Fqpp87T+w+T4940OnPwJlRgqrZNY/gOcamW517j+QwuTetdSjPyex+NMH
X9Y/hxBYWi9s7z/An2PqhLWfP1eUZ1dvWdY/CaVCrquA8T8AAAAAAAAAAGr0
KHegRNY/e4LU7Q==
       "], 0.1], Text3DBox[
       StyleBox["\<\"d\"\>",
        StripOnInput->False,
        LineColor->Hue[10100, 1, 0.7],
        FrontFaceColor->Hue[10100, 1, 0.7],
        BackFaceColor->Hue[10100, 1, 0.7],
        GraphicsColor->Hue[10100, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10100, 1, 0.7]], {0.46860526979258704`, 
       0.036021037976236576`, 0.35499369569003625`},
       Background->GrayLevel[1]]}, 
     {Hue[10302, 1, 0.7], 
      Arrow3DBox[{{0., 0.027185395779277588`, 0.36027070613110695`}, {
       0.0028339786880249296`, 0.3600649169727634, 1.215845095236038}}, 0.1], 
      Text3DBox[
       StyleBox["\<\"e\"\>",
        StripOnInput->False,
        LineColor->Hue[10302, 1, 0.7],
        FrontFaceColor->Hue[10302, 1, 0.7],
        BackFaceColor->Hue[10302, 1, 0.7],
        GraphicsColor->Hue[10302, 1, 0.7],
        FontFamily->"Helvetica",
        FontSize->Medium,
        FontSlant->Italic,
        FontColor->Hue[10302, 1, 0.7]], {0.0014169893440124648`, 
       0.19362515637602049`, 0.7880579006835725},
       Background->GrayLevel[1]]}}, {
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{0.0019820652316842047`, 1.2160260611562874`, 
       0.8826496145803808}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["11", {0.0019820652316842047`, 1.2160260611562874`, 
         0.8826496145803808}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{0.0028339786880249296`, 0.3600649169727634, 
       1.215845095236038}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["10", {0.0028339786880249296`, 0.3600649169727634, 
         1.215845095236038}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{1.0950029863609332`, 1.242310972487692, 0.8942896832172484}, 
       0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["6", {1.0950029863609332`, 1.242310972487692, 
         0.8942896832172484}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{1.0949795925681507`, 0.34790930475620413`, 
       1.2421474988781762`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["5", {1.0949795925681507`, 0.34790930475620413`, 
         1.2421474988781762`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{2.1881551031542186`, 1.2156429716301531`, 
       0.8822687870828565}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["1", {2.1881551031542186`, 1.2156429716301531`, 
         0.8822687870828565}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{2.1878752239116226`, 0.3599382959101707, 
       1.2152272198685425`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["4", {2.1878752239116226`, 0.3599382959101707, 
         1.2152272198685425`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{2.188656126376573, 0.8824947207420413, 
       0.026731819594790984`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["2", {2.188656126376573, 0.8824947207420413, 
         0.026731819594790984`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{2.188191784463818, 0.02690343695192654, 
       0.35958346441353695`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["3", {2.188191784463818, 0.02690343695192654, 
         0.35958346441353695`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{1.0942494676760863`, 0.8943211064369668, 0.}, 0.1], 
      {GrayLevel[0], 
       StyleBox[Text3DBox["7", {1.0942494676760863`, 0.8943211064369668, 0.}],
        
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{1.093913727478425, 0., 0.3479386485740351}, 0.1], 
      {GrayLevel[0], 
       StyleBox[Text3DBox["8", {1.093913727478425, 0., 0.3479386485740351}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{0.0002550999848951463, 0.8827671441054274, 
       0.027174767348906337`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["12", {0.0002550999848951463, 0.8827671441054274, 
         0.027174767348906337`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}, 
     {GrayLevel[1], EdgeForm[GrayLevel[0]], 
      SphereBox[{0., 0.027185395779277588`, 0.36027070613110695`}, 0.1], 
      {GrayLevel[0], 
       StyleBox[
        Text3DBox["9", {0., 0.027185395779277588`, 0.36027070613110695`}],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->Large,
        FontSlant->Italic]}}}},
   Annotation[#, 
    VertexCoordinateRules -> {{0.0019820652316842047`, 1.2160260611562874`, 
     0.8826496145803808}, {0.0028339786880249296`, 0.3600649169727634, 
     1.215845095236038}, {1.0950029863609332`, 1.242310972487692, 
     0.8942896832172484}, {1.0949795925681507`, 0.34790930475620413`, 
     1.2421474988781762`}, {2.1881551031542186`, 1.2156429716301531`, 
     0.8822687870828565}, {2.1878752239116226`, 0.3599382959101707, 
     1.2152272198685425`}, {2.188656126376573, 0.8824947207420413, 
     0.026731819594790984`}, {2.188191784463818, 0.02690343695192654, 
     0.35958346441353695`}, {1.0942494676760863`, 0.8943211064369668, 0.}, {
     1.093913727478425, 0., 0.3479386485740351}, {0.0002550999848951463, 
     0.8827671441054274, 0.027174767348906337`}, {0., 0.027185395779277588`, 
     0.36027070613110695`}}]& ],
  AspectRatio->Automatic,
  ImageSize->700,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellChangeTimes->{3.5930887893317833`*^9}]
}, Open  ]],

Cell[TextData[StyleBox["Make the components of the basis vector rho, in the \
kernel of the Laplacian",
 FontFamily->"Arial",
 FontSize->14]], "Text",
 CellChangeTimes->{{3.5573364553434753`*^9, 3.557336457437729*^9}, {
   3.55733648788798*^9, 3.5573367303420687`*^9}, {3.557336777261546*^9, 
   3.557336830142434*^9}, {3.557336869933217*^9, 3.557336930142406*^9}, {
   3.557336964381741*^9, 3.557336973939027*^9}, {3.557337005107644*^9, 
   3.557337107589531*^9}, {3.55733715531136*^9, 3.557337156149074*^9}, {
   3.557337197191593*^9, 3.5573373532260313`*^9}, {3.557337454417593*^9, 
   3.557337509398775*^9}, {3.557337998886497*^9, 3.557338048282792*^9}, {
   3.557338133542802*^9, 3.557338400797798*^9}, {3.557338437847659*^9, 
   3.5573384742237053`*^9}, {3.557338533712146*^9, 3.557338567063922*^9}, {
   3.5573508227295513`*^9, 3.557350860778597*^9}, {3.5573510006994743`*^9, 
   3.557351114044211*^9}, 3.557351253383313*^9, {3.5573516063996677`*^9, 
   3.557351612300694*^9}, {3.557351751325973*^9, 3.557351763947733*^9}, {
   3.557351899811076*^9, 3.5573519097130823`*^9}, {3.5573519747069263`*^9, 
   3.5573520924059*^9}, {3.557352695405736*^9, 3.557352810572102*^9}, {
   3.557415358965867*^9, 3.557415370787458*^9}, {3.557415813591751*^9, 
   3.557415907407928*^9}, {3.55741596703454*^9, 3.557416132101019*^9}, {
   3.557416317613041*^9, 3.5574169958677883`*^9}, {3.557417034842998*^9, 
   3.5574172165888453`*^9}, {3.557417382748787*^9, 3.55741739882644*^9}, {
   3.557417444802643*^9, 3.557417616172736*^9}, 3.557418731021221*^9, {
   3.5574187772941027`*^9, 3.557418962648896*^9}, {3.5574190859096746`*^9, 
   3.5574190891495333`*^9}, {3.557419147293167*^9, 3.557419252200601*^9}, {
   3.557419643599285*^9, 3.55741965110145*^9}, {3.557419682622394*^9, 
   3.557419718901723*^9}, {3.557419772097844*^9, 3.557420020787889*^9}, {
   3.5574200536568747`*^9, 3.55742008067167*^9}, {3.567110181612246*^9, 
   3.5671102263668823`*^9}, {3.5671102776439753`*^9, 3.567110316175557*^9}, {
   3.567110409018042*^9, 3.567110450666718*^9}, {3.569619427136961*^9, 
   3.569619466218553*^9}, {3.588042695174919*^9, 3.5880427072889338`*^9}, {
   3.593088212435068*^9, 3.593088255069174*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"initializing", " ", "variables", " ", "and", " ", "functions"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "find", " ", "number", " ", "of", " ", "nodes", " ", "in", " ", "graph"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numberofnodes", " ", "=", " ", 
     RowBox[{"Max", "[", 
      RowBox[{"MathematicaGraph", "/.", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"f_Integer", "->", "l_Integer"}], ",", "m_String"}], "}"}], 
        "\[RuleDelayed]", 
        RowBox[{"{", 
         RowBox[{"f", ",", "l"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhofnarg", "=", " ", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"identityelement", " ", "=", " ", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"m", "=", "1"}], ",", 
     RowBox[{"m", "\[LessEqual]", 
      RowBox[{"Length", "[", "listoflabels", "]"}]}], ",", 
     RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"rhofnarg", " ", "=", " ", 
       RowBox[{"rhofnarg", " ", "<>", " ", 
        RowBox[{
         RowBox[{"labelrule", "[", 
          RowBox[{"[", "m", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<_,\>\""}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"identityelement", " ", "=", " ", 
       RowBox[{"identityelement", " ", "<>", " ", "\"\<1,\>\""}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhoargument", " ", "=", " ", 
     RowBox[{"StringDrop", "[", 
      RowBox[{"rhofnarg", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"identity", " ", "=", " ", 
     RowBox[{"StringDrop", "[", 
      RowBox[{"identityelement", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"build", " ", "the", " ", 
     RowBox[{"rho", "'"}], "s", " ", "from", " ", "the", " ", "imported", " ",
      "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "numberofnodes"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ToExpression", "[", 
       RowBox[{"ToString", "[", 
        RowBox[{"\"\<rhofn\>\"", "<>", 
         RowBox[{"ToString", "[", "i", "]"}], "<>", 
         "\"\<=Import[NotebookDirectory[]<>\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
          "\"\<\\\"\>\"", "<>", "GraphName", "<>", "\"\<-\>\"", "<>", 
           RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<.txt\>\""}], "]"}],
          "<>", "\"\<\\\",\\\"Table\\\"]\>\""}], "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"totalarg", " ", "=", " ", "\"\<\>\""}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"m", "=", "1"}], ",", 
         RowBox[{"m", "\[LessEqual]", 
          RowBox[{"Length", "[", "listoflabels", "]"}]}], ",", 
         RowBox[{"m", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"ToString", "[", 
            RowBox[{"\"\<N\>\"", "<>", 
             RowBox[{"ToString", "[", "m", "]"}], "<>", 
             RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<=rhofn\>\"", "<>", 
             RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<[[All,\>\"", "<>", 
             RowBox[{"ToString", "[", "m", "]"}], "<>", "\"\<]]\>\""}], "]"}],
            "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"totalarg", " ", "=", " ", 
           RowBox[{"StringReplace", "[", 
            RowBox[{
             RowBox[{"totalarg", " ", "<>", " ", "\"\<*\>\"", "<>", 
              RowBox[{
               RowBox[{"labelrule", "[", 
                RowBox[{"[", "m", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<^N\>\"", "<>", 
              RowBox[{"ToString", "[", "m", "]"}], "<>", 
              RowBox[{"ToString", "[", "i", "]"}]}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\"\<*\>\"", "<>", 
                RowBox[{
                 RowBox[{"labelrule", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "\[Rule]", 
               RowBox[{
                RowBox[{"labelrule", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"ToString", "[", 
         RowBox[{"\"\<rhoexpression\>\"", "<>", 
          RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<=Total[\>\"", "<>", 
          "totalarg", "<>", "\"\<]\>\""}], "]"}], "]"}]}], ";", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"ToString", "[", 
        RowBox[{"\"\<rho\>\"", "<>", 
         RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<[\>\"", "<>", 
         "rhoargument", "<>", "\"\<]=rhoexpression\>\"", "<>", 
         RowBox[{"ToString", "[", "i", "]"}]}], "]"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sumstring", " ", "=", " ", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "numberofnodes"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sumstring", " ", "=", " ", 
       RowBox[{
       "sumstring", " ", "<>", "\"\<+\>\"", "<>", "\"\<rhoexpression\>\"", "<>", 
        RowBox[{"ToString", "[", "i", "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sumstring", "=", 
     RowBox[{"StringDrop", "[", 
      RowBox[{"sumstring", ",", "1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"ToExpression", "[", 
     RowBox[{
     "\"\<rhotot[\>\"", "<>", "rhoargument", "<>", "\"\<]=\>\"", "<>", 
      "sumstring"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.567096479786895*^9, 3.567096529195195*^9}, {
   3.567096599951558*^9, 3.5670967452009993`*^9}, {3.567096845187106*^9, 
   3.567096864042202*^9}, {3.56710492694907*^9, 3.567105001677526*^9}, {
   3.5696196184844103`*^9, 3.569619619000195*^9}, {3.5696203202745113`*^9, 
   3.5696203346600227`*^9}, {3.569708450736434*^9, 3.569708502588567*^9}, {
   3.569708537409513*^9, 3.569708539196775*^9}, {3.5697101636999063`*^9, 
   3.569710169845883*^9}, {3.569710620894732*^9, 3.5697106612772083`*^9}, {
   3.569715683019404*^9, 3.569715694091157*^9}, {3.569719453946583*^9, 
   3.569719482699815*^9}, {3.569771617075288*^9, 3.5697716174446907`*^9}, {
   3.56977725240506*^9, 3.56977725283821*^9}, {3.57141125529171*^9, 
   3.571411327847703*^9}, {3.5714127301218157`*^9, 3.5714127483970127`*^9}, {
   3.5721501854318027`*^9, 3.572150368331098*^9}, {3.572150415440815*^9, 
   3.57215042009759*^9}, {3.572153191974716*^9, 3.5721531997178593`*^9}, {
   3.57215339303246*^9, 3.5721534500451508`*^9}, {3.5721878337369013`*^9, 
   3.572187957993022*^9}, {3.57218868134371*^9, 3.5721886843618*^9}, {
   3.572188775599893*^9, 3.5721888161598263`*^9}, {3.5721889738352747`*^9, 
   3.572188987243351*^9}, {3.572189037173562*^9, 3.572189037396826*^9}, {
   3.572189079375972*^9, 3.572189183020879*^9}, {3.572189242481347*^9, 
   3.572189300580998*^9}, {3.5721893529534607`*^9, 3.572189355680992*^9}, {
   3.572190519944748*^9, 3.5721905234908743`*^9}, {3.5721914983906116`*^9, 
   3.572191498724887*^9}, {3.572191557103319*^9, 3.572191559236329*^9}, {
   3.572191648287588*^9, 3.572191789462426*^9}, {3.5721918711608877`*^9, 
   3.572191881937211*^9}, {3.572191965910149*^9, 3.572192009577553*^9}, {
   3.572199989623046*^9, 3.572200088723256*^9}, {3.572200256355047*^9, 
   3.57220027463579*^9}, {3.572200329712462*^9, 3.572200334585155*^9}, {
   3.572202485974539*^9, 3.572202489992475*^9}, 3.572203731750198*^9, {
   3.5880427172884893`*^9, 3.5880427695440273`*^9}, {3.588042887619659*^9, 
   3.588042889107978*^9}, {3.588070755917676*^9, 3.588070776128374*^9}, {
   3.5880711102315407`*^9, 3.588071408928907*^9}, {3.58807143916967*^9, 
   3.588071453012877*^9}, {3.588071483887466*^9, 3.588071489345862*^9}, {
   3.588071520364265*^9, 3.588071605183412*^9}, {3.588071857154109*^9, 
   3.588071859402079*^9}, {3.588071898556972*^9, 3.588071939143592*^9}, {
   3.588071973719277*^9, 3.588072329748619*^9}, {3.588072361168646*^9, 
   3.588072474278161*^9}, {3.588077013975954*^9, 3.588077018146*^9}, {
   3.588077081726479*^9, 3.58807710299741*^9}, {3.588077146309256*^9, 
   3.588077181743085*^9}, {3.588077231435206*^9, 3.5880773541670227`*^9}, {
   3.588077387571361*^9, 3.588077429569016*^9}, 3.5880774627354*^9, {
   3.588077626136794*^9, 3.588077628338602*^9}, {3.588078486153451*^9, 
   3.588078544670775*^9}, {3.588078758314563*^9, 3.588078766216092*^9}, {
   3.588078856428338*^9, 3.588078860778191*^9}, {3.5880790051195097`*^9, 
   3.58807906253157*^9}, {3.588079098120182*^9, 3.588079256766789*^9}, {
   3.588085978889915*^9, 3.588085982874989*^9}, {3.58808766115942*^9, 
   3.588087671077436*^9}, 3.5880886149080553`*^9, {3.591027461831753*^9, 
   3.591027462722608*^9}, {3.591033626729451*^9, 3.591033652498722*^9}, {
   3.591920827197814*^9, 3.591920831540658*^9}, {3.591920961232853*^9, 
   3.59192098251875*^9}, {3.591922469082778*^9, 3.59192247562808*^9}, {
   3.5919225445513363`*^9, 3.591922545318962*^9}, {3.59192258397395*^9, 
   3.591922590654903*^9}, {3.5919226851157703`*^9, 3.591922686571149*^9}, 
   3.5930882047196503`*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[TextData[StyleBox["Work out the total number of spanning trees in the \
graph",
 FontFamily->"Arial",
 FontSize->14]], "Text",
 CellChangeTimes->{{3.5573364553434753`*^9, 3.557336457437729*^9}, {
   3.55733648788798*^9, 3.5573367303420687`*^9}, {3.557336777261546*^9, 
   3.557336830142434*^9}, {3.557336869933217*^9, 3.557336930142406*^9}, {
   3.557336964381741*^9, 3.557336973939027*^9}, {3.557337005107644*^9, 
   3.557337107589531*^9}, {3.55733715531136*^9, 3.557337156149074*^9}, {
   3.557337197191593*^9, 3.5573373532260313`*^9}, {3.557337454417593*^9, 
   3.557337509398775*^9}, {3.557337998886497*^9, 3.557338048282792*^9}, {
   3.557338133542802*^9, 3.557338400797798*^9}, {3.557338437847659*^9, 
   3.5573384742237053`*^9}, {3.557338533712146*^9, 3.557338567063922*^9}, {
   3.5573508227295513`*^9, 3.557350860778597*^9}, {3.5573510006994743`*^9, 
   3.557351114044211*^9}, 3.557351253383313*^9, {3.5573516063996677`*^9, 
   3.557351612300694*^9}, {3.557351751325973*^9, 3.557351763947733*^9}, {
   3.557351899811076*^9, 3.5573519097130823`*^9}, {3.5573519747069263`*^9, 
   3.5573520924059*^9}, {3.557352695405736*^9, 3.557352810572102*^9}, {
   3.557415358965867*^9, 3.557415370787458*^9}, {3.557415813591751*^9, 
   3.557415907407928*^9}, {3.55741596703454*^9, 3.557416132101019*^9}, {
   3.557416317613041*^9, 3.5574169958677883`*^9}, {3.557417034842998*^9, 
   3.5574172165888453`*^9}, {3.557417382748787*^9, 3.55741739882644*^9}, {
   3.557417444802643*^9, 3.557417616172736*^9}, 3.557418731021221*^9, {
   3.5574187772941027`*^9, 3.557418962648896*^9}, {3.5574190859096746`*^9, 
   3.5574190891495333`*^9}, {3.557419147293167*^9, 3.557419252200601*^9}, {
   3.557419643599285*^9, 3.55741965110145*^9}, {3.557419682622394*^9, 
   3.557419718901723*^9}, {3.557419772097844*^9, 3.557420020787889*^9}, {
   3.5574200536568747`*^9, 3.55742008067167*^9}, {3.567110181612246*^9, 
   3.5671102263668823`*^9}, {3.5671102776439753`*^9, 3.567110316175557*^9}, {
   3.567110409018042*^9, 3.567110450666718*^9}, {3.569619427136961*^9, 
   3.569619466218553*^9}, {3.588042695174919*^9, 3.5880427072889338`*^9}, {
   3.588087689687481*^9, 3.588087713541383*^9}, {3.593088455883512*^9, 
   3.593088473885962*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "number", " ", "of", " ", "spanning", " ", "trees", " ", "is", " ", "sum", 
    " ", "of", " ", 
    RowBox[{"rho_i", "'"}], "s", " ", "at", " ", "identity"}], " ", "*)"}], 
  " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"rhosum", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "numberofnodes"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"rhosum", " ", "=", " ", 
      RowBox[{"rhosum", " ", "+", " ", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<rho\>\"", "<>", 
         RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<[\>\"", "<>", 
         "identity", "<>", "\"\<]\>\""}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "rhosum"}]}]], "Input",
 CellChangeTimes->{{3.5671102303045673`*^9, 3.567110238751122*^9}, {
   3.5880786911808367`*^9, 3.588078708961845*^9}, {3.5880788048436832`*^9, 
   3.5880788050022078`*^9}, 3.588085872576847*^9, {3.591925559703712*^9, 
   3.591925560615677*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData["53376"], "Output",
 CellChangeTimes->{3.593088805137182*^9}]
}, Open  ]],

Cell[TextData[StyleBox["Print out the rhoi. Note that rhotot gives rho1 + ... \
+ rhon (ie: the partition function)",
 FontFamily->"Arial",
 FontSize->14]], "Text",
 CellChangeTimes->{{3.5573364553434753`*^9, 3.557336457437729*^9}, {
   3.55733648788798*^9, 3.5573367303420687`*^9}, {3.557336777261546*^9, 
   3.557336830142434*^9}, {3.557336869933217*^9, 3.557336930142406*^9}, {
   3.557336964381741*^9, 3.557336973939027*^9}, {3.557337005107644*^9, 
   3.557337107589531*^9}, {3.55733715531136*^9, 3.557337156149074*^9}, {
   3.557337197191593*^9, 3.5573373532260313`*^9}, {3.557337454417593*^9, 
   3.557337509398775*^9}, {3.557337998886497*^9, 3.557338048282792*^9}, {
   3.557338133542802*^9, 3.557338400797798*^9}, {3.557338437847659*^9, 
   3.5573384742237053`*^9}, {3.557338533712146*^9, 3.557338567063922*^9}, {
   3.5573508227295513`*^9, 3.557350860778597*^9}, {3.5573510006994743`*^9, 
   3.557351114044211*^9}, 3.557351253383313*^9, {3.5573516063996677`*^9, 
   3.557351612300694*^9}, {3.557351751325973*^9, 3.557351763947733*^9}, {
   3.557351899811076*^9, 3.5573519097130823`*^9}, {3.5573519747069263`*^9, 
   3.5573520924059*^9}, {3.557352695405736*^9, 3.557352810572102*^9}, {
   3.557415358965867*^9, 3.557415370787458*^9}, {3.557415813591751*^9, 
   3.557415907407928*^9}, {3.55741596703454*^9, 3.557416132101019*^9}, {
   3.557416317613041*^9, 3.5574169958677883`*^9}, {3.557417034842998*^9, 
   3.5574172165888453`*^9}, {3.557417382748787*^9, 3.55741739882644*^9}, {
   3.557417444802643*^9, 3.557417616172736*^9}, 3.557418731021221*^9, {
   3.5574187772941027`*^9, 3.557418962648896*^9}, {3.5574190859096746`*^9, 
   3.5574190891495333`*^9}, {3.557419147293167*^9, 3.557419252200601*^9}, {
   3.557419643599285*^9, 3.55741965110145*^9}, {3.557419682622394*^9, 
   3.557419718901723*^9}, {3.557419772097844*^9, 3.557420020787889*^9}, {
   3.5574200536568747`*^9, 3.55742008067167*^9}, {3.567110181612246*^9, 
   3.5671102263668823`*^9}, {3.5671102776439753`*^9, 3.567110316175557*^9}, {
   3.567110409018042*^9, 3.567110450666718*^9}, {3.569619427136961*^9, 
   3.569619466218553*^9}, {3.588042695174919*^9, 3.5880427072889338`*^9}, {
   3.588087689687481*^9, 3.588087695063026*^9}, {3.5930882897096643`*^9, 
   3.593088290484497*^9}, {3.593088524635847*^9, 3.593088561378879*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"print", " ", "out", " ", "rhos"}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "numberofnodes"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"\"\<rho\>\"", "<>", 
       RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<[\>\"", "<>", 
       RowBox[{"StringReplace", "[", 
        RowBox[{"rhoargument", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<_\>\"", "\[Rule]", "\"\<\>\""}], "}"}]}], "]"}], "<>", 
       "\"\<]=\>\""}], 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<rho\>\"", "<>", 
        RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<[\>\"", "<>", 
        RowBox[{"StringReplace", "[", 
         RowBox[{"rhoargument", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<_\>\"", "\[Rule]", "\"\<\>\""}], "}"}]}], "]"}], 
        "<>", "\"\<]\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.567096479786895*^9, 3.567096529195195*^9}, {
   3.567096599951558*^9, 3.5670967452009993`*^9}, {3.567096845187106*^9, 
   3.567096864042202*^9}, {3.56710492694907*^9, 3.567105001677526*^9}, {
   3.5696196184844103`*^9, 3.569619619000195*^9}, {3.5696203202745113`*^9, 
   3.5696203346600227`*^9}, {3.569708450736434*^9, 3.569708502588567*^9}, {
   3.569708537409513*^9, 3.569708539196775*^9}, {3.5697101636999063`*^9, 
   3.569710169845883*^9}, {3.569710620894732*^9, 3.5697106612772083`*^9}, {
   3.569715683019404*^9, 3.569715694091157*^9}, {3.569719453946583*^9, 
   3.569719482699815*^9}, {3.569771617075288*^9, 3.5697716174446907`*^9}, {
   3.56977725240506*^9, 3.56977725283821*^9}, {3.57141125529171*^9, 
   3.571411327847703*^9}, {3.5714127301218157`*^9, 3.5714127483970127`*^9}, {
   3.5721501854318027`*^9, 3.572150368331098*^9}, {3.572150415440815*^9, 
   3.57215042009759*^9}, {3.572153191974716*^9, 3.5721531997178593`*^9}, {
   3.57215339303246*^9, 3.5721534500451508`*^9}, {3.5721878337369013`*^9, 
   3.572187957993022*^9}, {3.57218868134371*^9, 3.5721886843618*^9}, {
   3.572188775599893*^9, 3.5721888161598263`*^9}, {3.5721889738352747`*^9, 
   3.572188987243351*^9}, {3.572189037173562*^9, 3.572189037396826*^9}, {
   3.572189079375972*^9, 3.572189183020879*^9}, {3.572189242481347*^9, 
   3.572189300580998*^9}, {3.5721893529534607`*^9, 3.572189355680992*^9}, {
   3.572190519944748*^9, 3.5721905234908743`*^9}, {3.5721914983906116`*^9, 
   3.572191498724887*^9}, {3.572191557103319*^9, 3.572191559236329*^9}, {
   3.572191648287588*^9, 3.572191789462426*^9}, {3.5721918711608877`*^9, 
   3.572191881937211*^9}, {3.572191965910149*^9, 3.572192009577553*^9}, {
   3.572199989623046*^9, 3.572200088723256*^9}, {3.572200256355047*^9, 
   3.57220027463579*^9}, {3.572200329712462*^9, 3.572200334585155*^9}, {
   3.572202485974539*^9, 3.572202489992475*^9}, 3.572203731750198*^9, {
   3.5880427172884893`*^9, 3.5880427695440273`*^9}, {3.588042887619659*^9, 
   3.588042889107978*^9}, {3.588070755917676*^9, 3.588070776128374*^9}, {
   3.5880711102315407`*^9, 3.588071408928907*^9}, {3.58807143916967*^9, 
   3.588071453012877*^9}, {3.588071483887466*^9, 3.588071489345862*^9}, {
   3.588071520364265*^9, 3.588071605183412*^9}, {3.588071857154109*^9, 
   3.588071859402079*^9}, {3.588071898556972*^9, 3.588071939143592*^9}, {
   3.588071973719277*^9, 3.588072329748619*^9}, {3.588072361168646*^9, 
   3.588072474278161*^9}, {3.588077013975954*^9, 3.588077018146*^9}, {
   3.588077081726479*^9, 3.58807710299741*^9}, {3.588077146309256*^9, 
   3.588077181743085*^9}, {3.588077231435206*^9, 3.5880773541670227`*^9}, {
   3.588077387571361*^9, 3.588077429569016*^9}, 3.5880774627354*^9, {
   3.588077626136794*^9, 3.588077628338602*^9}, {3.58807798096462*^9, 
   3.588077986709041*^9}, {3.588078127137662*^9, 3.588078169941621*^9}, {
   3.588078556968278*^9, 3.588078559454545*^9}, {3.588078773175408*^9, 
   3.588078775230679*^9}, {3.588079368020664*^9, 3.588079464593273*^9}, {
   3.588079519986273*^9, 3.588079521352106*^9}, {3.593088577041272*^9, 
   3.593088577682694*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\<\"rho1[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"71", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"103", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"84", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"94", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"88", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"75", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"104", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "7"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.5930888121587257`*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho2[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"69", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"88", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"73", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"54", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"43", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812258347*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho3[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"43", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"87", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"80", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"88", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"67", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"84", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812274688*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho4[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "8"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "7"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "7"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"76", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "7"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"108", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"72", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"61", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"97", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"118", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "6"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"88", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"124", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"71", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"42", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "4"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.5930888122959757`*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho5[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"91", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"54", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"57", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"53", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"84", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"152", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"106", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"112", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"166", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"56", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"84", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"98", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"73", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"141", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"73", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"147", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"76", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"111", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"119", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"30", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"77", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"43", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"24", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"20", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"20", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"32", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"18", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"10", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "7"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812320281*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho6[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"83", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"9", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"91", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"59", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"66", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"13", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"87", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"109", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"34", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"57", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"42", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"77", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"24", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"74", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"36", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"11", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"11", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"18", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"11", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"11", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812342804*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho7[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812362481*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho8[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"43", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"56", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"60", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"86", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"79", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"42", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"54", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"71", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"54", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.5930888123796883`*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho9[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"47", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812395302*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho10[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"60", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"29", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"60", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "7"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"150", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"177", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"97", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"84", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"221", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"205", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"178", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"163", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"57", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"70", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"167", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"102", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "6"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"77", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"103", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"157", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"175", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"83", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"76", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"110", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"294", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"281", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"164", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"345", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"230", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"48", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"76", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"40", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"207", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"134", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"26", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"90", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"144", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"12", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "5"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"134", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"141", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"199", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"150", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"36", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"87", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"36", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"258", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"176", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"38", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"150", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"222", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"78", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"56", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"44", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"56", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"32", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"40", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"105", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"77", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"18", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"109", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"42", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"28", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"62", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"98", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"36", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"66", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"52", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"12", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"14", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"22", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"12", " ", "a", " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "c", " ", 
     SuperscriptBox["e", "8"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "8"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "8"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.5930888124999533`*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho11[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"72", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"78", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"71", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"71", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"12", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"37", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"25", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"15", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"5", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "6"], " ", "c", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"31", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"162", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"190", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"103", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"25", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"255", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"239", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"92", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"118", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"79", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"110", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"275", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"234", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"78", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"151", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"299", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"168", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"90", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"98", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"174", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"87", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"106", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"119", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"32", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"37", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"29", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"77", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"103", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"65", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"19", " ", "a", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "6"], " ", "c", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"157", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"175", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"83", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["b", "5"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"92", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"76", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"130", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"344", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"325", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"129", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"208", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"436", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"289", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"60", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"105", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"158", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"56", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"187", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"364", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"217", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"222", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"292", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"86", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"77", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"52", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"105", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"123", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"34", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"89", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"50", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"16", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"18", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"134", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"141", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"63", " ", "a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"199", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"150", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"51", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"87", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"36", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"156", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"326", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"217", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"208", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"299", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"102", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"84", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"8", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", "d", " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"139", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"185", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"58", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"133", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"86", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"28", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"36", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"22", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"105", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"77", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"68", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"109", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"42", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"32", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"4", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"90", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"132", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"46", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"96", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"70", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"24", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", "d", " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"38", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"26", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "6"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"36", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"26", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"8", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"20", " ", "a", " ", "b", " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"16", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d", " ", 
     SuperscriptBox["e", "7"]}], "+", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c", " ", 
     SuperscriptBox["e", "8"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["e", "8"]}], "+", 
    RowBox[{"4", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["e", "8"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812520893*^9}],

Cell[BoxData[
 RowBox[{"\<\"rho12[a,b,c,d,e]=\"\>", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "6"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "5"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"26", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", "e"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", "e"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["a", "5"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"33", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"54", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"48", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "5"], " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"30", " ", 
     SuperscriptBox["a", "4"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"44", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["b", "4"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "4"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"38", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"6", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"14", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"5", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "4"], " ", 
     SuperscriptBox["e", "3"]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"19", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"23", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"10", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"6", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "3"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"7", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"7", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "3"], " ", 
     SuperscriptBox["e", "4"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["e", "5"]}]}], ")"}]}]], "Print",
 CellChangeTimes->{3.593088812538184*^9}]
}, Open  ]]
}, Open  ]],

Cell["\<\
Construct the numerator of the Pho5 gene regulation function (see the paper) \
and count the number of monomials\
\>", "Text",
 CellChangeTimes->{{3.593089129668796*^9, 3.59308916997427*^9}, {
  3.593089219804411*^9, 3.593089233024888*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grfnumerator", "[", 
   RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_", ",", "e_"}], "]"}], ":=", 
  " ", 
  RowBox[{
   RowBox[{"rho2", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "+", 
   RowBox[{"rho3", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "+", 
   RowBox[{"rho7", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "+", 
   RowBox[{"rho8", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "+", 
   RowBox[{"rho9", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "+", 
   RowBox[{"rho12", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", 
  RowBox[{"MonomialList", "[", 
   RowBox[{"grfnumerator", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.5930888874518127`*^9, 3.5930890122225323`*^9}, {
  3.593089238679497*^9, 3.593089239766028*^9}}],

Cell[BoxData["261"], "Output",
 CellChangeTimes->{3.59308924283517*^9}]
}, Open  ]],

Cell["\<\
The denominator of the gene regulation function is given by the partition \
function\
\>", "Text",
 CellChangeTimes->{{3.593089182818081*^9, 3.593089210023098*^9}},
 Background->RGBColor[1, 1, 0.85]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"MonomialList", "[", 
   RowBox[{"rhotot", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.593089113697094*^9, 3.593089116182624*^9}}],

Cell[BoxData["500"], "Output",
 CellChangeTimes->{3.593089117125968*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{946, 868},
WindowMargins->{{Automatic, 59}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Linux x86 (64-bit) (February 7, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[422, 15, 684, 10, 65, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1131, 29, 102, 1, 35, "Subsubsection"],
Cell[1236, 32, 3521, 59, 278, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4794, 96, 96, 1, 35, "Subsubsection"],
Cell[4893, 99, 2300, 49, 208, "Text"],
Cell[7196, 150, 550, 13, 30, "Text"],
Cell[7749, 165, 319, 5, 45, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8105, 175, 112, 1, 35, "Subsubsection"],
Cell[8220, 178, 553, 12, 46, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8822, 196, 340, 7, 46, "Subsubtitle"],
Cell[9165, 205, 1146, 18, 71, "Input"],
Cell[10314, 225, 5373, 118, 379, "Input"],
Cell[15690, 345, 165, 4, 46, "Text"],
Cell[CellGroupData[{
Cell[15880, 353, 5955, 112, 357, "Input"],
Cell[21838, 467, 48392, 977, 448, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70267, 1449, 5068, 100, 313, "Input"],
Cell[75338, 1551, 44008, 975, 633, "Output"]
}, Open  ]],
Cell[119361, 2529, 2225, 32, 46, "Text"],
Cell[121589, 2563, 10095, 205, 863, "Input"],
Cell[131687, 2770, 2256, 33, 46, "Text"],
Cell[CellGroupData[{
Cell[133968, 2807, 1224, 28, 181, "Input"],
Cell[135195, 2837, 74, 1, 32, "Output"]
}, Open  ]],
Cell[135284, 2841, 2337, 33, 46, "Text"],
Cell[CellGroupData[{
Cell[137646, 2878, 4229, 71, 159, "Input"],
Cell[CellGroupData[{
Cell[141900, 2953, 22335, 601, 493, "Print"],
Cell[164238, 3556, 19167, 524, 433, "Print"],
Cell[183408, 4082, 20726, 572, 453, "Print"],
Cell[204137, 4656, 24049, 650, 533, "Print"],
Cell[228189, 5308, 28665, 761, 633, "Print"],
Cell[256857, 6071, 24071, 632, 533, "Print"],
Cell[280931, 6705, 19057, 511, 413, "Print"],
Cell[299991, 7218, 23322, 631, 513, "Print"],
Cell[323316, 7851, 16998, 461, 373, "Print"],
Cell[340317, 8314, 32932, 880, 733, "Print"],
Cell[373252, 9196, 36651, 976, 813, "Print"],
Cell[409906, 10174, 16294, 434, 373, "Print"]
}, Open  ]]
}, Open  ]],
Cell[426227, 10612, 285, 6, 47, "Text"],
Cell[CellGroupData[{
Cell[426537, 10622, 1065, 25, 99, "Input"],
Cell[427605, 10649, 71, 1, 32, "Output"]
}, Open  ]],
Cell[427691, 10653, 209, 5, 47, "Text"],
Cell[CellGroupData[{
Cell[427925, 10662, 256, 6, 32, "Input"],
Cell[428184, 10670, 72, 1, 32, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

